/*BDE Tabellen*/
/*Mitarbeiterverzeichnis mit den Sollwerten für Arbeitsstunden, Urlaubstagen usw für die Mitarbeiter, Bei Urlaub wirde auch der Überhang aus der Vergangenheit berechnet */
 CREATE TABLE llv (
  ll_minr                  integer NOT NULL CONSTRAINT xtt5033 PRIMARY KEY,
  ll_rfid                  text,  --VARCHAR(150) UNIQUE  -- etwa 11 Zeichen pro dezimaler ID (32 Bit)
  ll_ad_krz                varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,
  ll_grup                  varchar(20),-- NOT NULL DEFAULT '',--eventuell später wegen update
  ll_abteilung             varchar(30),
  ll_abteilungsleiter      boolean DEFAULT FALSE,
  ll_einstd                date DEFAULT current_date,
  ll_endd                  date,
  ll_passwd                varchar,                     -- siehe https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/System-Benuter_und_-Benutzergruppen > Infos zur Benutzerverwaltung in PostgreSQL und PRODAT/BDE
  ll_prszzeit              boolean NOT NULL DEFAULT (NOT tsystem.settings__getbool('BDENoPrsz')), -- Personalzeiterfassung aktiv
  ll_auftrzeit             boolean NOT NULL DEFAULT FALSE,
  ll_auftrzeit_force       boolean NOT NULL DEFAULT FALSE, -- Auftragszeit ist Pflicht: Präsenzzeit anstempeln geht sofort auf Auftrag. Bei Abmelden Auftrag kommt zwangsweise sofort Auftrag anstempeln. Bei wiederkommen am gleichen Tag wird der letzte Auftrag vorgeschlagen, ansonsten analog Präsenzzeit kommen (geht sofort Auftrag anstempeln auf)
  ll_auftrzeit_sollpr      numeric,                     -- Prozentsatz der Präsenzzeit, die als Auftragszeit erfasst sein muss. BDE-Stempeln blinkt rot, wenn mit zu wenig Auftragszeit abgestempelt wird.
  ll_standplan_mo          varchar(20), -- REFERENCES tplan ON UPDATE CASCADE; -- siehe X TableContraints.sql
  ll_standplan_di          varchar(20), -- REFERENCES tplan ON UPDATE CASCADE; -- siehe X TableContraints.sql
  ll_standplan_mi          varchar(20), -- REFERENCES tplan ON UPDATE CASCADE; -- siehe X TableContraints.sql
  ll_standplan_do          varchar(20), -- REFERENCES tplan ON UPDATE CASCADE; -- siehe X TableContraints.sql
  ll_standplan_fr          varchar(20), -- REFERENCES tplan ON UPDATE CASCADE; -- siehe X TableContraints.sql
  ll_standplan_sa          varchar(20), -- REFERENCES tplan ON UPDATE CASCADE; -- siehe X TableContraints.sql
  ll_standplan_so          varchar(20), -- REFERENCES tplan ON UPDATE CASCADE; -- siehe X TableContraints.sql
  ll_urlaub                numeric,
  ll_urlaub_days           boolean NOT NULL DEFAULT TRUE,
  ll_urlaub_ges            numeric,                      -- Jahresurlaub des Mitarbeiters
  ll_urlaub_hidden         boolean NOT NULL DEFAULT false,  -- nicht in Urlaubsplantafel anzeigen
  ll_urlaub_bewill_vorl    boolean NOT NULL DEFAULT FALSE, -- kann vorläufig Bewilligen (nur wenn Mehrstufige Bewilligung aktiv)
  ll_urlaub_bewill         boolean NOT NULL DEFAULT FALSE, -- kann (definitiv) Bewilligen
  ll_urlaub_bewill_notself boolean NOT NULL DEFAULT TRUE,  -- darf sich nicht selber bewilligen
  ll_urlaub_betriebsurlaub_calc boolean NOT NULL DEFAULT true,

  ll_stuko_buch            numeric(12,2) NOT NULL DEFAULT 0,
  ll_stuko_max             numeric(12,2),
  ll_fixauszahl            numeric,

  ll_sa_request            boolean DEFAULT FALSE, --Überstundenauszahlung darf beantragt werden

  ll_kap_mo                numeric,
  ll_kap_di                numeric,
  ll_kap_mi                numeric,
  ll_kap_do                numeric,
  ll_kap_fr                numeric,
  ll_kap_sa                numeric,
  ll_kap_so                numeric,
  ll_db_usename            varchar(10) UNIQUE,
  ll_db_login              boolean NOT NULL DEFAULT FALSE, -- wenn true hat Mitarbeiter DB-Login in pg_user
  ll_allg1                 varchar(20),
  ll_allg2                 varchar(20),
  ll_ks                    varchar(9) REFERENCES ksv ON UPDATE CASCADE,
  ll_DoLohnExport          boolean NOT NULL DEFAULT TRUE,
  ll_autostemp             boolean NOT NULL DEFAULT true,
  ll_selecttplan           boolean NOT NULL DEFAULT false,
  ll_stand_ab_id           integer, -- REFERENCES bdeabgruende; siehe X TableContraints.sql
  --ll_signature        OID
  ll_win_usr               varchar(256)   -- Windows-Login
  );


 CREATE INDEX llv_ll_ad_krz ON llv (ll_ad_krz);
 CREATE INDEX llv_ll_db_usename_cast ON llv (CAST(ll_db_usename AS name));



-- siehe https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/System-Benuter_und_-Benutzergruppen > Infos zur Benutzerverwaltung in PostgreSQL und PRODAT/BDE
CREATE OR REPLACE FUNCTION llv__b_10_iu__userhandling_db() RETURNS TRIGGER AS $$
    DECLARE _mandant_user_group varchar = 'SYS.MANDANT.' || current_database();
    BEGIN
        IF new.ll_db_usename IS NULL THEN
           IF (TSystem.Settings__GetText('BDE_DEFAULTVAL__LL_DB_USENAME') = 'Adresskurzname') THEN
              new.ll_db_usename :=  new.ll_ad_krz;
           ELSE
              new.ll_db_usename :=  new.ll_minr;
           END IF;
        END IF;

        --
        IF TG_OP = 'UPDATE' THEN
           -- Benutzername veränder = rename
           IF     new.ll_db_usename IS DISTINCT FROM old.ll_db_usename
              AND     EXISTS (SELECT true FROM pg_user WHERE usename = old.ll_db_usename)
              AND NOT EXISTS (SELECT true FROM pg_user WHERE usename = new.ll_db_usename)
           THEN
              EXECUTE 'ALTER USER "' || CAST(old.ll_db_usename AS TEXT) || '"' ||
                      ' RENAME TO "' || CAST(new.ll_db_usename AS TEXT) || '"';
           END IF;

           -- Login auflösen bei ausgeschieden
           IF new.ll_db_login THEN
              IF     new.ll_endd IS DISTINCT FROM old.ll_endd
                 AND new.ll_endd IS NOT NULL
                 AND new.ll_endd < current_date
              THEN
                 new.ll_db_login := False;--nutzer scheidet anhand datum aus
              END IF;
           END IF;

           -- Falls Login-Status eines bestehenden Logins geändert wird, versuche das Login zu löschen.
           IF NOT new.ll_db_login AND old.ll_db_login AND EXISTS( SELECT true FROM pg_user WHERE usename = new.ll_db_usename) THEN
              EXECUTE 'REASSIGN OWNED BY "' || CAST(new.ll_db_usename AS TEXT) || '" TO "root"';
              EXECUTE 'DROP USER IF EXISTS "' || CAST(new.ll_db_usename AS TEXT) || '"';
           END IF;

        END IF; --'UPDATE'

        -- Nutzer anlegen oder löschen wenn Änderung in ll_db_login
        IF (new.ll_db_login) THEN -- Mitarbeiter soll Login bekommen
           IF (NOT EXISTS(SELECT true FROM pg_user WHERE usename = new.ll_db_usename)) THEN
              -- EXECUTE 'CREATE USER "' || CAST(new.ll_db_usename AS TEXT) || '"' ||
              --        '  WITH ENCRYPTED PASSWORD ''' || CAST(COALESCE(new.ll_passwd, lower(new.ll_db_usename)) AS TEXT) || ''' ';
              PERFORM TSystem.create__user( new.ll_db_usename, 'WITH ENCRYPTED PASSWORD ''' || CAST(COALESCE(new.ll_passwd, lower(new.ll_db_usename)) AS TEXT) || ''' ' );

           END IF;--falls nutzer doch schon existierte
           --
           IF TG_OP = 'UPDATE' THEN
              IF new.ll_passwd IS DISTINCT FROM old.ll_passwd THEN
                 -- Password change forbidden via setting
                 IF TSystem.Settings__GetBool( 'BDE__passwd__change__disabled' ) THEN
                    RAISE EXCEPTION 'password_change_denied xtt32005';
                 ELSE
                    EXECUTE 'ALTER USER "' || CAST(new.ll_db_usename AS TEXT) || '" ENCRYPTED PASSWORD ''' || CAST(COALESCE(new.ll_passwd, '') AS TEXT) || ''';';
                 END IF;
              END IF;
           END IF;
           --
        END IF;

        new.ll_db_login := EXISTS( SELECT true FROM pg_user WHERE usename = new.ll_db_usename); --durch Ändern Benutzernamen landen wir auf einem Login

        IF new.ll_db_login AND NOT TSystem.roles__user__group__is_in(new.ll_db_usename, 'SYS.Prodat-User') THEN -- #18548
           --- Zuweisung zur Gruppe "SYS.Prodat-User"
           EXECUTE 'GRANT "SYS.Prodat-User" TO "' || CAST(new.ll_db_usename AS TEXT) || '";';
        END IF;
        --

        IF new.ll_db_login AND EXISTS (SELECT true FROM pg_group WHERE groname = _mandant_user_group) AND NOT TSystem.roles__user__group__is_in(new.ll_db_usename, _mandant_user_group) THEN
           --- Zuweisung zur Gruppe "SYS.Prodat-User"
           EXECUTE 'GRANT "' || _mandant_user_group || '" TO "' || CAST(new.ll_db_usename AS TEXT) || '";';
        END IF;

        -- #16376 Personalanlage Passwort initial gleich Username, wenn Passwortwechsel überhaupt erlaubt ist
        IF TG_OP = 'INSERT' AND NOT TSystem.Settings__GetBool( 'BDE__passwd__change__disabled' ) AND new.ll_passwd IS null THEN
          new.ll_passwd := lower( new.ll_db_usename );
        END IF;

        RETURN new;
    END $$ LANGUAGE plpgsql;


 CREATE TRIGGER llv__b_10_iu__userhandling_db
  BEFORE INSERT OR UPDATE
  OF ll_db_login, ll_db_usename, ll_endd, ll_passwd
  ON llv
  FOR EACH ROW
  EXECUTE PROCEDURE llv__b_10_iu__userhandling_db();
--
CREATE OR REPLACE FUNCTION llv__b_11_iu__ll_passwd() RETURNS TRIGGER AS $$
    BEGIN
        IF trim(new.ll_passwd)='' then
               new.ll_passwd:=NULL;
        END IF;
        --wir "verstecken" das Passwort wieder
        new.ll_passwd := md5(new.ll_passwd);
        RETURN new;
    END $$ LANGUAGE plpgsql;

 CREATE TRIGGER llv__b_11_iu__ll_passwd
  BEFORE INSERT OR UPDATE
  OF ll_passwd
  ON llv
  FOR EACH ROW
  EXECUTE PROCEDURE llv__b_11_iu__ll_passwd();
--
--RFID-Abgrenzung zu 32Bit-Format
CREATE OR REPLACE FUNCTION llv__b_60_iu__ll_rfid() RETURNS TRIGGER AS $$
    DECLARE
      new_rfid BIGINT;
    BEGIN
        IF     new.ll_rfid IS NOT NULL
           AND trim(new.ll_rfid) ~ '^[0-9]+$'
        THEN
           new_rfid := (trim(new.ll_rfid)::bigint & x'FFFFFFFF'::bigint);
           IF trim(new.ll_rfid) != new_rfid THEN
             PERFORM PRODAT_HINT(lang_text(26546) || E'\r\n' || new.ll_rfid || ' -> ' || new_rfid || E'\r\n\r\n' || 'TRIGGER FUNCTION llv__b_60_iu__ll_rfid()');
             new.ll_rfid := new_rfid::text;
           END IF;
        END IF;
        RETURN new;
    END $$ LANGUAGE plpgsql;

  CREATE TRIGGER llv__b_60_iu__ll_rfid
    BEFORE INSERT OR UPDATE
    OF ll_rfid
    ON llv
    FOR EACH ROW
    EXECUTE PROCEDURE llv__b_60_iu__ll_rfid();
--
CREATE OR REPLACE FUNCTION llv__b_70_u__stuko_buch_max() RETURNS TRIGGER AS $$
  BEGIN
   IF new.ll_stuko_max IS NOT NULL THEN
          IF new.ll_stuko_buch > new.ll_stuko_max THEN
             new.ll_stuko_buch := new.ll_stuko_max;--maximales stundenkonto, falls wir mit max stundenkonto arbeiten
          END IF;
   END IF;
   --
   RETURN new;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER llv__b_70_u__stuko_buch_max
  BEFORE UPDATE
  OF ll_stuko_buch
  ON llv
  FOR EACH ROW
  EXECUTE PROCEDURE llv__b_70_u__stuko_buch_max();
--
--Funktion zum erzeugen und löschen eines Login bei Änderung von LLV.ll_db_login
CREATE OR REPLACE FUNCTION llv__a_iu() RETURNS TRIGGER AS $$
  BEGIN
    IF TG_OP='UPDATE' THEN
        IF old.ll_endd IS NULL AND new.ll_endd IS NOT NULL THEN
            DELETE FROM mitpln WHERE mpl_date>new.ll_endd AND mpl_minr=new.ll_minr;
        END IF;
    END IF;
    --
    IF NOT EXISTS(SELECT true FROM personal WHERE new.ll_ad_krz=pers_krz) THEN
        INSERT INTO personal (pers_krz) VALUES (new.ll_ad_krz);
    END IF;
    --
    IF TG_OP='INSERT' THEN /* Automatisches Anlegen der Rolle 'Alle Mitarbeiter' */
        INSERT INTO anfmitarbzu(amz_minr, amz_mar_id) SELECT ll_minr,0 FROM llv WHERE new.ll_minr = ll_minr;
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER llv__a_iu
    AFTER INSERT OR UPDATE
    ON llv
    FOR EACH ROW
    EXECUTE PROCEDURE llv__a_iu();
--
CREATE OR REPLACE FUNCTION llv__a_iud() RETURNS TRIGGER AS $$
  BEGIN
   IF tg_op='INSERT' OR tg_op='UPDATE' THEN
          PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', new.ll_ad_krz);
          PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', new.ll_minr);
          PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', new.ll_db_usename);
   END IF;
   --
   IF tg_op='DELETE' OR tg_op='UPDATE' THEN
          PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', old.ll_ad_krz);
          PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', old.ll_minr);
          PERFORM tcache.function_cache_setdirty_1param('nameAufloesen', old.ll_db_usename);
   END IF;
   IF tg_op='DELETE' THEN
          DELETE FROM userbuttons WHERE usrbt_user=old.ll_db_usename;
          RETURN old;
   ELSE
          RETURN new;
   END IF;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER llv__a_iud
   AFTER INSERT OR UPDATE OR DELETE
   ON llv
   FOR EACH ROW
   EXECUTE PROCEDURE llv__a_iud();
--
---  #20713
CREATE OR REPLACE FUNCTION tpersonal.llv__ll_db_login__userbuttons(
    IN _ll_db_usename_new   varchar DEFAULT TSystem.current_user_ll_db_usename( true )
) RETURNS void AS $$

  BEGIN
   --
   IF NOT EXISTS( SELECT true FROM userbuttons WHERE usrbt_user=_ll_db_usename_new ) THEN
       BEGIN
            INSERT INTO userbuttons( usrbt_mm_id, usrbt_user ) VALUES
            ( 27    , _ll_db_usename_new )/*Adress*/,

            ( 30    , _ll_db_usename_new )/*Artikel*/,
            ( 32    , _ll_db_usename_new )/*Artikelcode*/,

            ( 23    , _ll_db_usename_new )/*AVOR*/,
            ( 38    , _ll_db_usename_new )/*Stückliste*/,
            ( 25    , _ll_db_usename_new )/*Kostenstellen*/,
            ( 253   , _ll_db_usename_new )/*Kostenstellentexte*/,

            ( 64    , _ll_db_usename_new )/*Verkauf.Interessenten*/,
            ( 57    , _ll_db_usename_new )/*Verkauf.Verkauf*/,

            ( 3091  , _ll_db_usename_new )/*Einkauf.Bestellvorschläge*/,
            ( 3372  , _ll_db_usename_new )/*Einkauf.Einkauf*/,

            ( 83    , _ll_db_usename_new )/*Planung.ABK erstellen*/,
            ( 127   , _ll_db_usename_new )/*Planung.ABK Bearbeiten*/,
            ( 131   , _ll_db_usename_new )/*Planung.Auswärts Erstellen*/,
            ( 133   , _ll_db_usename_new )/*Planung.Ausw#rts Rück*/,

            ( 11    , _ll_db_usename_new ) /*BDE: Zeiterfassung*/,
            ( 200   , _ll_db_usename_new )/*BDE: Auftragszeiten (ABK) bearbeiten*/,

            ( 68    , _ll_db_usename_new ) /*Lager.LagZu Frei*/,
            ( 69    , _ll_db_usename_new ) /*Lager.LagZu Bestellbezogen*/,
            ( 262, _ll_db_usename_new )/*Lager.Lagzu Tabellarisch*/,
            ( 72    , _ll_db_usename_new ) /*Lager.Lagzu Bearbeiten*/,
            ( 70    , _ll_db_usename_new ) /*Lager.LagAb Frei*/,
            ( 71    , _ll_db_usename_new ) /*Lager.LagAb Auftg*/,
            ( 264   , _ll_db_usename_new )/*Lager.LagAb ABK Tabellarisch*/,
            ( 263   , _ll_db_usename_new )/*Lager.LagAb Bearbeiten*/,

            ( 666679, _ll_db_usename_new )/*Lager.StandardLagerorte*/,
            ( 527   , _ll_db_usename_new )/*Lager.Lieferschein*/,

            ( 81    , _ll_db_usename_new ) /*RechnungA.Rechnung*/
            ;
       EXCEPTION
            WHEN others THEN
                 RAISE WARNING '%', sqlerrm;
       END;
   END IF;
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION llv__a_iu__ll_db_login__userbuttons() RETURNS TRIGGER AS $$
  BEGIN
   --- #20713
   IF tg_op = 'UPDATE' THEN
        IF new.ll_db_usename <> old.ll_db_usename THEN
            UPDATE userbuttons SET usrbt_user = new.ll_db_usename WHERE usrbt_user = old.ll_db_usename;
        END IF;
   END IF;

   PERFORM tpersonal.llv__ll_db_login__userbuttons( new.ll_db_usename );

   RETURN new;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER llv__a_iu__ll_db_login__userbuttons
   AFTER INSERT OR UPDATE
   OF ll_db_login, ll_db_usename
   ON llv
   FOR EACH ROW
     WHEN ( new.ll_db_login )
   EXECUTE PROCEDURE llv__a_iu__ll_db_login__userbuttons();
--

--
CREATE OR REPLACE FUNCTION current_user_minr() RETURNS integer AS $$

    SELECT ll_minr
      FROM llv
    WHERE ll_db_usename = current_user;

  $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;
--


/* siehe A0 role_system.sql
FUNCTION llv__a_iud_synchUserrights()
TRIGGER llv__a_iud_synchUserrights
*/


-- TABLE llv_stuko_history für Stundenhistorie der Mitarbeiter
 CREATE TABLE llv_stuko_history
  (llsh_id               serial NOT NULL PRIMARY KEY,
   llsh_ll_minr          integer NOT NULL REFERENCES llv ON UPDATE CASCADE,
   llsh_monthyear        varchar(6) NOT NULL,
   llsh_date             date NOT NULL DEFAULT current_date, -- Datum der Verbuchung
   llsh_urlaub           numeric(12,2),
   llsh_stuko            numeric(12,2),
   llsh_stuko_diff       numeric(12,2), -- Stundenkonto +/- des Monats auf Basis der Daten; Erweiterung #21000
   llsh_rp               numeric(12,2), -- Sicherung Raucherpausen des Monats; #21000
   llsh_sa_stunden       numeric(12,2), -- Sicherung korrespondierender Eintrag in stundauszahl; #21000
   llsh_sa_urlaub        numeric(12,2), -- Sicherung korrespondierender Eintrag in stundauszahl; #21000
   llsh_txt              text
  );

 CREATE UNIQUE INDEX llv_stuko_history_minr_my ON llv_stuko_history(llsh_ll_minr, llsh_monthyear);

 --Überprüft ob der Zeitraum schon Verbucht ist/ in llv_stuko_history enthalten.
 CREATE OR REPLACE FUNCTION check_valid_bde_date(
     IN  _m integer,
     IN  _d date
     )
     RETURNS boolean
     AS $$
     DECLARE _result boolean;
     BEGIN
        SELECT max(llsh_monthyear) < date_to_yearmonth_dec(_d)
          INTO _result
          FROM llv_stuko_history
         WHERE llsh_ll_minr = _m;

        RETURN coalesce(_result, true);
     END $$ LANGUAGE plpgsql;

 CREATE OR REPLACE FUNCTION tpersonal.llv_stuko_history__buch_month__last(
     IN  _m integer,
     IN  _d date,
     OUT last_buch_month integer,
     OUT last_buch_month__is_previous bool
     )
     RETURNS record
     AS $$
     BEGIN
        SELECT max(llsh_monthyear),
               max(llsh_monthyear) = date_to_yearmonth_dec(_d - '1 month'::interval)
          INTO last_buch_month,
               last_buch_month__is_previous
          FROM llv_stuko_history
         WHERE llsh_ll_minr = _m;

        -- neuer Mitarbeiter, kein Vormonat
        IF last_buch_month__is_previous IS NULL
           AND NOT EXISTS (SELECT true FROM llv_stuko_history WHERE llsh_ll_minr = _m)
        THEN
           last_buch_month__is_previous := coalesce(last_buch_month__is_previous, true);
        END IF;

        RETURN;
     END $$ LANGUAGE plpgsql;


 CREATE OR REPLACE FUNCTION llv_stuko_history__b_d() RETURNS TRIGGER AS $$
     DECLARE _stuko numeric;
             _urlaub numeric;
     BEGIN
         IF EXISTS(SELECT true
                     FROM llv_stuko_history
                    WHERE llsh_ll_minr   = old.llsh_ll_minr
                      AND llsh_monthyear > old.llsh_monthyear
                    )
         THEN
                 RAISE EXCEPTION '%', Format(lang_text(29177) /*'Kann immer nur die letzte Verbuchung entfernen.'*/);
         END IF;

         --vorherige Stundenkonten wiederherstellen
         SELECT llsh_stuko, llsh_urlaub
           INTO _stuko, _urlaub
           FROM llv_stuko_history
          WHERE llsh_ll_minr   = old.llsh_ll_minr
            AND llsh_monthyear < old.llsh_monthyear
          ORDER BY
                llsh_monthyear
           DESC LIMIT 1;

         UPDATE llv
            SET ll_stuko_buch = coalesce(_stuko,  0),
                -- wenn der Januar zurückgebucht wird, muss auch der Urlaub für das Gesmatjahr wiederhergestellt werden
                ll_urlaub     = coalesce(_urlaub, 0) + ifthen(old.llsh_monthyear NOT LIKE '____00', 0, ll_urlaub_ges)
          WHERE ll_minr = old.llsh_ll_minr;

         --
         RETURN old;
     END $$ LANGUAGE plpgsql;

     CREATE TRIGGER llv_stuko_history__b_d
       BEFORE DELETE
       ON llv_stuko_history
       FOR EACH ROW
       EXECUTE PROCEDURE llv_stuko_history__b_d();
--

--
CREATE OR REPLACE FUNCTION llv_stuko_history__a_d() RETURNS TRIGGER AS $$
  DECLARE
      stuko NUMERIC;
      urlaub NUMERIC;
  BEGIN
    -- Stempelungen wieder öffnen
    UPDATE bdep SET
      bd_buch = false
    WHERE bd_minr = old.llsh_ll_minr
      AND bd_individwt_mpl_date IN (
            SELECT mpl_date
            FROM mitpln
            WHERE mpl_buch
              AND mpl_minr = old.llsh_ll_minr
              AND mpl_formonth = old.llsh_monthyear
          )
    ;

    -- Abwesenheiten können Anfang und Ende auch um mitpln.mpl_date haben (Urlaub 1.8.15 bis 8.8.15, aber Tagespläne 3.8.15 bis 7.8.15).
    -- Muss hier geschlossen werden, sonst Probleme mit Trigger bdepab__a_iud: UPDATE mitpln.
    UPDATE bdepab SET
      bdab_buch = false
    WHERE bdab_minr = old.llsh_ll_minr
      AND EXISTS(
            SELECT true
            FROM mitpln
            WHERE mpl_minr = old.llsh_ll_minr
              AND mpl_formonth = old.llsh_monthyear
              AND mpl_date BETWEEN bdab_anf AND COALESCE(bdab_end, bdab_anf)
          )
    ;

    -- Stundenauszahlungen
    UPDATE stundauszahl SET
      sa_buch = false
    WHERE sa_buch
      AND sa_minr = old.llsh_ll_minr
      AND date_to_yearmonth_dec(sa_date - TSystem.Settings__GetInteger('anfdaymonth')) = old.llsh_monthyear
    ;

    -- Mitarbeiterplan (Kopftabelle)
    UPDATE mitpln SET
      mpl_buch = false
    WHERE mpl_buch
      AND mpl_minr = old.llsh_ll_minr
      AND mpl_formonth = old.llsh_monthyear
    ;

    RETURN old;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER llv_stuko_history__a_d
    AFTER DELETE
    ON llv_stuko_history
    FOR EACH ROW
    EXECUTE PROCEDURE llv_stuko_history__a_d();
--

-- TABLE llv_url_anspr Urlaubsanspruch  #5857, #5106 Erweiterung
 CREATE TABLE llv_url_anspr (
    uan_ll_minr         integer NOT NULL REFERENCES llv ON UPDATE CASCADE,      -- Referenz ll_minr
    uan_year            integer DEFAULT (date_part('year',CURRENT_DATE) + 1),   -- jahr, ab dem der Urlaubsanspruch
    uan_urlaub_ges      numeric,                                                -- Jahresanspruch analog ll_urlaub_ges (enthält Summe uan_urlaub_ansp + Zusatzurlaub)
    uan_zusatz          numeric,                                                -- Zusatzurlaub > Sonderurlaub, Behinderung
    uan_urlaub_anspr    numeric,                                                -- Ausgangsanspruch (ohne Zusatzurlaub)
    uan_done            boolean NOT NULL DEFAULT FALSE,                            -- Erledigt-Status ~ nach v2 #5106 nicht mehr in Verwendung
    uan_txt             text                                                    -- Zusatztext für Bemerkungen
  );

 ALTER TABLE llv_url_anspr ADD CONSTRAINT llv_url_anspr__year_minr_unique PRIMARY KEY(uan_year, uan_ll_minr);

 -- Urlaubsanspruch und Resturlaub durch Änderung Urlaubsstaffel anpassen #5106
 -- Anspruch gesamt berechnen aus Ausgangsanspruch und Zusatzurlaub
 CREATE OR REPLACE FUNCTION llv_url_anspr__b_iu() RETURNS TRIGGER AS $$
  BEGIN
    IF tg_op='INSERT' THEN
      new.uan_urlaub_ges:=coalesce(new.uan_urlaub_anspr,0)+coalesce(new.uan_zusatz,0);
      -- im aktuellen Jahr Frage zum Anpassen von Jahresurlaub und Resturlaub
      IF (new.uan_year=date_part('year', CURRENT_DATE)) THEN
        -- Eine Aktualisierung von Jahresurlaub und Resturlaub kann erst nach dem Monatsabschluss des Vorjahres durchgeführt werden
        IF NOT tpersonal.llv_stuko_history__checkYearDone(new.uan_ll_minr) THEN
            RAISE EXCEPTION '%', lang_text(25339);
        END IF;
        --Die Eingabeoberfläche stellt sicher, dass uan_urlaub_anspr ll_urlaub_ges entspricht > damit kannn die gleiche PRODAT_MESSAGE verwendet werden
        PERFORM PRODAT_MESSAGE_YES_NO( 25337, 'Message.llv.upd.urlaub.yes', NULL,
          new.uan_urlaub_ges || ',' || new.uan_zusatz || ',0,' || new.uan_ll_minr );
      END IF;
    END IF;
    IF tg_op='UPDATE' THEN
      IF ( new.uan_urlaub_anspr IS DISTINCT FROM old.uan_urlaub_anspr ) OR (new.uan_zusatz IS DISTINCT FROM old.uan_zusatz) THEN
        new.uan_urlaub_ges:=coalesce(new.uan_urlaub_anspr,0)+coalesce(new.uan_zusatz,0);
        -- im aktuellen Jahr Frage zum Anpassen von Jahresurlaub und Resturlaub
        IF (new.uan_year=date_part('year', CURRENT_DATE)) THEN
          -- Eine Aktualisierung von Jahresurlaub und Resturlaub kann erst nach dem Monatsabschluss des Vorjahres durchgeführt werden
          IF NOT tpersonal.llv_stuko_history__checkYearDone(new.uan_ll_minr) THEN
            RAISE EXCEPTION '%', lang_text(25339);
          END IF;
          PERFORM PRODAT_MESSAGE_YES_NO( 25337, 'Message.llv.upd.urlaub.yes', NULL,
            new.uan_urlaub_ges || ',' || new.uan_zusatz || ',' || old.uan_zusatz || ',' || new.uan_ll_minr );
        END IF;
      END IF;
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER llv_url_anspr__b_iu
  BEFORE INSERT OR UPDATE
  ON llv_url_anspr
  FOR EACH ROW
  EXECUTE PROCEDURE llv_url_anspr__b_iu();
--

CREATE OR REPLACE FUNCTION set_llv_urlaubges(yyyy integer DEFAULT NULL, minr integer DEFAULT NULL) RETURNS VOID AS $$
 DECLARE curryear integer;
 BEGIN
     curryear:=date_part('year', CURRENT_DATE);
     -- Jahresurlaub MitVz setzen
     UPDATE llv
        SET ll_urlaub_ges = uan_urlaub_ges
       FROM llv_url_anspr
      WHERE uan_ll_minr = ll_minr
        AND NOT uan_done
        AND ll_minr  = coalesce(minr,ll_minr) -- nur dieser Mitarbeiter für Monatsabschluss
        AND uan_year = coalesce(yyyy, curryear) AND uan_year>=curryear; --Zusatzsicherungen
     -- Erledigt-Status Staffel setzen (wird nach Ablaufänderung #5106 eigentlich nicht mehr benötigt)
     UPDATE llv_url_anspr
        SET uan_done = True
      WHERE uan_ll_minr = coalesce(minr,uan_ll_minr) -- nur dieser Mitarbeiter für Monatsabschluss
        AND uan_year    = coalesce(yyyy, curryear)
        AND uan_year >= curryear; --Zusatzsicherungen
     --
     RETURN;
 END $$ LANGUAGE plpgsql;


-- Abwesenheits- / Ausfallgründe
 CREATE TABLE bdeabgruende (
  ab_id                serial NOT NULL PRIMARY KEY,
  ab_grup              integer,                                                      -- TextNr zur Klassifizierung (Gruppierung Ausfallgründe)
  ab_txt               varchar(50) NOT NULL,
  ab_txt_short         varchar(2), --DEFAULT substring(ab_txt from 1 for 1),         -- Kurzvariante von ab_txt, für die Anzeige in zu kurzen Events der Plantafel (kein Feldzugriffe im Default erlaubt ... wird daher im OnBeforePost gemacht)
  ab_stu               numeric,
  ab_stu_abzu          integer DEFAULT NULL CHECK (ab_stu_abzu=1 OR ab_stu_abzu=-1), -- Gutschrift Plus=1; Gutschrift Abzug=-1 #7034
  ab_vhz               boolean NOT NULL DEFAULT FALSE,                                  -- bei Wahr wird die Vorholzeit mit in den Sollwert gerechnet und damit abgezogen
  ab_show              boolean NOT NULL DEFAULT TRUE,                                   -- Wenn Wahr, werden Abwesenheiten mit diesem Grund in der Oberfläche angezeigt
  ab_terminal          boolean NOT NULL DEFAULT TRUE,                                   -- kommt auf dem Terminal
  ab_autobewill        boolean NOT NULL DEFAULT FALSE,                                  -- Automatische Bewilligung siehe bdepabbe__b_iu
  ab_allg1             integer,                                                      -- Bei Mattis = Addison-Lohnart zum Verrechnen
  ab_allg2             varchar(10),                                                  -- Bei Mattis = Addison-KS zum Verrechnen
  ab_delete            boolean NOT NULL DEFAULT false,                                  -- abwesenheit nicht mehr verwenden
  ab_antrag            boolean NOT NULL DEFAULT true,                                   -- darf beantragt werden
  ab_color             integer NOT NULL DEFAULT x'F0CAA6'::int,                      -- Farbe dieser Events in der Urlaubsplantafel (CimLightBlue)
  ab_anonym            boolean NOT NULL DEFAULT true,                                   -- Soll anonymisiert werden
  ab_anonym_txt        varchar(50)                                                   -- Alternativer Text für die Anonymisierung (Standard ist XTT 5126)
 );

-- Prüffunktion ob Abwesenheit Präsenzzeitplus oder Präsenzzeitminus sein soll, #7034
 CREATE OR REPLACE FUNCTION bdeabgruende__Gutschrift_Is(abid integer) RETURNS boolean AS $$
  BEGIN
    RETURN COALESCE(ab_stu_abzu, 0) = 1 FROM bdeabgruende WHERE ab_id = abid;
  END $$ LANGUAGE plpgsql;
--

 /* Vorgaben: Maschinen-Ausfallgründe */
 CREATE TABLE bdeausgruende
  (aus_id               serial NOT NULL PRIMARY KEY,
   aus_grup             integer,/*TextNr zur Klassifizierung (Gruppierung Ausfallgründe)*/
   aus_txt              varchar(50),
   aus_stu              numeric,
   aus_ks               varchar(9) REFERENCES ksv ON UPDATE CASCADE
  );

 /* Vorgaben: Produktions-Ausschussgründe */
 CREATE TABLE bdea_ausschussgruende
  (asg_id               serial PRIMARY KEY,
   asg_descr            varchar(50) NOT NULL UNIQUE,    -- Bezeichnung
   asg_txt              text                            -- Hinweistext
  );

 /**/

 CREATE OR REPLACE FUNCTION bdep_join_index_func(DATE, integer) RETURNS varchar AS $$
  BEGIN
   RETURN CAST($1 AS varchar)||'~'||CAST($2 AS varchar);
  END $$ LANGUAGE plpgsql IMMUTABLE;
--

-- Präsenzzeit
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Stempeln
CREATE TABLE bdep (
  bd_id                      serial PRIMARY KEY,
  bd_minr                    integer NOT NULL REFERENCES llv ON UPDATE CASCADE DEFERRABLE INITIALLY DEFERRED, -- DEFERRED: fKey-CASCADE muss zum Schluss ausgeführt werden, sonst wird mitpln-Eintrag (Trigger) erzeugt, der in Konflikt mit dem fKey-CASCADE steht.
  bd_firstofday              boolean,
  -- bd_formonth               varchar(8),
  bd_anf                     timestamp(0) without time zone NOT NULL DEFAULT currenttime(),
  bd_end                     timestamp(0) without time zone,
  bd_anf_rund                timestamp(0) without time zone,
  bd_end_rund                timestamp(0) without time zone,
  bd_txt                     text,
  bd_aus_id                  integer REFERENCES bdeabgruende,
  bd_buch                    boolean NOT NULL DEFAULT false,
  bd_karenz                  boolean DEFAULT true,
  bd_karenz_end              boolean DEFAULT true,
  bd_karenz_antrag           boolean DEFAULT null, -- #21321 null um impliziten Status zu verwenden
  bd_karenz_antrag_end       boolean DEFAULT null,
  bd_blockpause              numeric,
  bd_gleitpause              numeric,        -- abzu innerhalb dieser Stempelung wegen Pausenzeitberührung
  bd_restpause               numeric,        -- Hält, wieviel Pausenanteil diese Stempelug geltend macht. Ich stempele in eine Pause von 15 minuten mit 5 Minuten hinein, habe ich selbst also 5 Minuten bd_gleitpause und bd_restpause ist 10 Minuten
  bd_stemphint               varchar(50),
  bd_saldo                   numeric,        -- Saldo der Stempelung OHNE Pausen (bereits abgezogen wurden bd_gleitpause und bd_blockpause)
  bd_nachtstunden            numeric,        -- Nachtstundenanteil der Präsenzzeit
  bd_terminal                varchar(150),
  bd_individwt_mpl_date      DATE NOT NULL, -- individueller Werktag. Diese Stempelung gehört ggf. zu vorherigem Werktag entspr. Arbeitszeit, siehe Ticket #13041.
  -- System (tables__generate_missing_fields)
  modified_by                varchar(32),
  dbrid                      varchar(32) NOT NULL DEFAULT nextval('db_id_seq'), --#11363
  --
  CONSTRAINT xtt5037  CHECK(bd_end IS NULL OR bd_anf < bd_end),
  CONSTRAINT xtt16246 CHECK(bd_end IS NULL OR (bd_end - bd_anf) < '31 days'::INTERVAL),
  CONSTRAINT bdep_bd_buch_incomplete CHECK (bd_buch IS false OR (bd_anf IS NOT null AND bd_end IS NOT null))

); -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Stempeln

-- Indizes
    CREATE INDEX bdep_anf ON bdep(bd_anf, bd_end);
    CREATE INDEX bdep_minr_anf ON bdep(bd_minr, bd_anf, bd_end);
    CREATE INDEX bdep_minr_individwt_mpl_date ON bdep(bd_minr, bd_individwt_mpl_date);
    CREATE INDEX bdep_bdanf_date ON bdep (timestamp_to_date(bd_anf));
    CREATE INDEX bdep_bdend_date ON bdep (timestamp_to_date(bd_end));
    -- für die Zukunft:
    -- CREATE INDEX bdep_anf_end_range ON bdep USING gist( tsrange(bd_anf, bd_end, '[]') );
    -- CREATE INDEX bdep_anf_end_rund_range ON bdep USING gist( tsrange(bd_anf_rund, bd_end_rund, '[]') );
    CREATE INDEX bdep_anw ON bdep(bd_id) WHERE bd_end IS NULL;
    CREATE INDEX bdep_buch_minr ON bdep(bd_minr) WHERE NOT bd_buch;
    CREATE INDEX bdep_join_index ON bdep(bdep_join_index_func(CAST(bd_anf AS DATE), bd_minr));
    CREATE INDEX bdep_bdanf_as_date ON bdep(CAST(bd_anf AS DATE));
--

--
CREATE OR REPLACE FUNCTION TPersonal.bdeabgruende_GetAbwGrundListe(OUT ab_id INTEGER, OUT ab_txt VARCHAR(40), OnlyTerminal BOOL DEFAULT FALSE) RETURNS SETOF RECORD AS $$
  DECLARE sql VARCHAR;
    rec RECORD;
  BEGIN
      sql = 'SELECT ab_id, ab_txt FROM bdeabgruende WHERE ';
      IF TSystem.Settings__GetBool('BDE_RP') THEN
        sql = sql || 'ab_id=103';
      ELSE
        sql = sql || 'ab_show AND NOT ab_delete' || CASE WHEN OnlyTerminal THEN ' AND ab_terminal' ELSE '' END;
      END IF;
      --ORDER BY funktioniert an der Stelle nicht, weil die Sortierung im Gerät eingegeben ist
      FOR rec IN EXECUTE sql LOOP
        ab_id  = rec.ab_id;
        ab_txt = rec.ab_txt::VARCHAR(40); --Achtung: ab_txt in Datenbank VARCHAR(50) in Terminal aber nur VARCHAR(40) möglich!
        RETURN NEXT;
      END LOOP;
  END $$ LANGUAGE plpgsql;
--

 /*trigger der abfängt, das 2* Präsenzzeit angestempelt wird*/

 /*erneutes Anstempeln innerhalb einer bestehenden Anstempelung ist unzulässig (ändern)*/
 /*dazu prüfen :
    ANFANGSDATUM
        wenn ein anfangsdatum kleiner/vor  neues Anfangsdatum (spätere Stempelungen interess nicht) und dessen Enddatum grösser/später neues Anfangsdatum.
        die neue beginntstempelung liegt also inmitten einer bestehenden, geht nich

        alt_anfang <<<<<< neues anfang <<<<<<< alt ende

    ENDDATUM

        alt_anfang <<<<< neu_ende <<<<<alt_ende

    GESAMTDATUM
        wenn anfang und ende in mitte wird durch Triggertechnologie automatisch...
        wenn Anfang vor Anfang und Ende nach Ende geht nich

        neu anfang <<<<< alt anfang <<<<<< alt ende <<<<<< neu ende
 */

--
CREATE OR REPLACE FUNCTION tpersonal.bde__llv_standplan__get(_d date, _t time(0), minr integer) RETURNS varchar AS $$
 DECLARE tplanname varchar;
 BEGIN
    IF (extract(dow FROM _d) BETWEEN 1 AND 4) THEN -- mo-do
        -- Uhrzeit => llv_autoplan
        IF _t IS NOT NULL THEN
           tplanname := llpl_tpl_name FROM llv_autoplan WHERE llpl_minr = minr AND (_t BETWEEN llpl_anf AND llpl_end);
        END IF;
        --
        -- Uhrzeit => llv_autoplan
        IF tplanname IS NULL THEN
           IF    extract(dow FROM _d) = 1 THEN
              tplanname := ll_standplan_mo FROM llv WHERE ll_minr = minr;
           ELSIF extract(dow FROM _d) = 2 THEN
              tplanname := ll_standplan_di FROM llv WHERE ll_minr = minr;
           ELSIF extract(dow FROM _d) = 3 THEN
              tplanname := ll_standplan_mi FROM llv WHERE ll_minr = minr;
           ELSE
              tplanname := ll_standplan_do FROM llv WHERE ll_minr = minr;
           END IF;--extract dow 1..4
        END IF;-- between 1 and 4 (Montag-Donnerstag)
    ELSIF (extract(dow FROM _d) = 5) THEN -- freitag
        IF _t IS NOT NULL THEN    --keine Anfangszeit, also einfach nur den Tagesplan eingefügt
              tplanname := llpl_tpl_name_fr FROM llv_autoplan WHERE llpl_minr = minr AND (_t BETWEEN llpl_anf AND llpl_end);
        END IF;
        --
        IF tplanname IS NULL THEN
             tplanname := ll_standplan_fr FROM llv WHERE ll_minr = minr;
        END IF;
    ELSIF extract(dow FROM _d) = 6 THEN   --- Samstag
        IF _t IS NOT NULL THEN    --keine Anfangszeit, also einfach nur den Tagesplan eingefügt
            tplanname := llpl_tpl_name_sa FROM llv_autoplan WHERE llpl_minr = minr AND (_t BETWEEN llpl_anf AND llpl_end);
        END IF;
        IF tplanname IS NULL THEN
            tplanname := ll_standplan_sa FROM llv WHERE ll_minr = minr;
        END IF;
    ELSE--- Sonntag
        IF _t IS NOT NULL THEN    --keine Anfangszeit, also einfach nur den Tagesplan eingefügt
            tplanname := llpl_tpl_name_so FROM llv_autoplan WHERE llpl_minr = minr AND (_t BETWEEN llpl_anf AND llpl_end);
        END IF;
        IF tplanname IS NULL THEN
            tplanname := ll_standplan_so FROM llv WHERE ll_minr = minr;
        END IF;
    END IF;
  RETURN tplanname;
 END $$ LANGUAGE plpgsql;
--

/*  Bis auf Weiteres deaktiviert, da Anpassung #11733 und nie praktisch im Einsatz gewesen
    in #11733 Entscheidung, dass Abteilungsleiter ihre eigenen Zeit bearbeiten dürfen
-- Einschränkung der Bearbeitung der Karenzen auf Personaler und Abteilungsleiter (Überstundenfreigabe)
CREATE OR REPLACE FUNCTION bdep__b_10_u_karenz() RETURNS TRIGGER AS $$
  BEGIN
    -- WHEN (TSystem.Settings__GetBool('Praesenzzeit.Personaler.Abteilungsleiter'))
    IF EXISTS(SELECT true FROM pg_user WHERE usesysid IN (SELECT unnest(grolist) FROM pg_group WHERE groname='SYS.Personaldaten') AND usename = current_user) THEN -- Wenn aktueller Nutzer in Benutzergruppe SYS.Personaldaten, dann Bearbeitung vollständig erlaubt (auch eigene).
        RETURN new;
    ELSIF (SELECT ll_abteilungsleiter FROM llv WHERE COALESCE(ll_abteilung, '') = (SELECT COALESCE(llv_mitarbeiter.ll_abteilung, '') FROM llv AS llv_mitarbeiter WHERE llv_mitarbeiter.ll_minr = new.bd_minr) -- Wenn aktueller Nutzer Abteilungsleiter der Abteilung des gestempelten MA, dann erlaubt.
        AND ll_db_usename = current_user) THEN

        IF new.bd_minr = (SELECT ll_minr FROM llv WHERE ll_db_usename = current_user) THEN -- außer der Abteilungsleiter sich selbst.
            RAISE EXCEPTION '%', lang_text(16321);
        END IF;

        RETURN new;
    ELSE
        RAISE EXCEPTION '%', lang_text(16322);
    END IF;

  END $$ LANGUAGE plpgsql;
  --

  CREATE TRIGGER bdep__b_10_u_karenz
    BEFORE UPDATE
    OF bd_karenz, bd_karenz_end
    ON bdep
    FOR EACH ROW
    WHEN (TSystem.Settings__GetBool('Praesenzzeit.Personaler.Abteilungsleiter'))
    EXECUTE PROCEDURE bdep__b_10_u_karenz();  */
--

-- Befüllung des neuen Feldes individueller Werktag (bd_individwt_mpl_date), siehe #13386 bzw.#13041.
-- Before-Trigger kümmert sich erstmal nur um den eigenen Datensatz.
CREATE OR REPLACE FUNCTION bdep__b_10_iu__individwt() RETURNS TRIGGER AS $$
  BEGIN
    new.bd_individwt_mpl_date := TPersonal.bdep__individwt__get_date__by_bd_anf_minr(new.bd_anf, new.bd_minr)::DATE;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdep__b_10_iu__individwt
    BEFORE INSERT OR UPDATE
    OF bd_anf, bd_end, bd_minr
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__b_10_iu__individwt();
--

--  #13995 [table bde] bd_buch = TRUE, nur wenn bd_anf und bd_end gefüllt sind
CREATE OR REPLACE FUNCTION bdep__b_15_iu__bd_buch__bd_end__is_null () RETURNS TRIGGER AS $$
  BEGIN
    --z.B.: ERROR:  Verbuchen nicht möglich! Ende-Buchung zu ID: 645, Minr: 1 - Max Mustermann, Anmeldung: 2019-12-20 08:00:00 fehlt.
    RAISE EXCEPTION '%', FORMAT(lang_text(29729), new.bd_id, new.bd_minr || ' - ' || (SELECT nameAufloesen(new.bd_minr)), new.bd_anf);
    RETURN new;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER bdep__b_15_iu__bd_buch__bd_end__is_null
    BEFORE INSERT OR UPDATE
    OF bd_buch
    ON bdep
    FOR EACH ROW
    WHEN (new.bd_buch AND new.bd_end IS NULL)
    EXECUTE PROCEDURE bdep__b_15_iu__bd_buch__bd_end__is_null ();
--

-- After-Trigger für Ermittlung des individuellen Werktages, siehe #13386 bzw.#13041.
-- Dient dem Nachrechnen der evtl. betroffenen Stempelungen,
-- inkl. antriggern der Summenberechnungen.
CREATE OR REPLACE FUNCTION bdep__a_10_iud__individwt() RETURNS TRIGGER AS $$
  DECLARE
      new_anf   TIMESTAMP;
      old_anf   TIMESTAMP;
      new_minr  INTEGER;
      old_minr  INTEGER;
      _do_recalc boolean;
  BEGIN
    -- old und new auslesen zur Vereinfachung
    IF    TG_OP = 'INSERT' THEN
        new_anf   := new.bd_anf;
        new_minr  := new.bd_minr;
    ELSIF TG_OP = 'UPDATE' THEN
        new_anf   := new.bd_anf;
        old_anf   := old.bd_anf;
        new_minr  := new.bd_minr;
        old_minr  := old.bd_minr;
    ELSE        -- DELETE
        old_anf   := old.bd_anf;
        old_minr  := old.bd_minr;
    END IF;

    -- Auslösen der Neuberechnung des ind. Werktags der evtl. anderen betroffenen Stempelungen
    _do_recalc := coalesce(TPersonal.bdep__individwt__recalc(new_anf, old_anf, coalesce(new_minr, old_minr)), false);

    -- Das Ende-Datum wird so geändert, dass der Individ WT der Folgestempelung nun rausfällt, die Folgestempelung muss über recalc laufen
    IF     TG_OP = 'UPDATE'
       AND new.bd_end IS DISTINCT FROM old.bd_end
    THEN
       _do_recalc := _do_recalc OR coalesce(TPersonal.bdep__individwt__recalc(null, old.bd_end, coalesce(new_minr, old_minr)), false);
    END IF;

    -- Wenn sich beim UPDATE die MiNr geändert hat, dann auch zwingend den alten nochmal nachrechnen.
    IF     TG_OP = 'UPDATE'
       AND new_minr <> old_minr
    THEN
        _do_recalc := _do_recalc OR coalesce(TPersonal.bdep__individwt__recalc(null, old_anf, old_minr), false);
    END IF;

    -- Fall Löschen der vorherigen Stempelung aktualisiert den Individ WT der folgenden
    IF TG_OP = 'DELETE'
    THEN
       _do_recalc := _do_recalc OR coalesce(tpersonal.bdep__individwt__recalc(null, old.bd_end, coalesce(new_minr, old_minr)), false);
    END IF;

    -- Auslösen der Neuberechnung der Summen für gestern, heute und morgen der geänderten Stempelungen
    -- Durch schieben der Stempelung kann sich der Tag der Stempelung verändern, sowie der Tag an dem die Stempelung evtl vorher war.
    -- ob das so geschickt ist - oder man das besser in bdep__individwt__recalc anstoßen sollte - frage ich (DS) aber funktioniert erstmal

    IF _do_recalc THEN
       PERFORM tpersonal.mitpln__saldo__recalc__prsz_neu(
                        coalesce(new_anf, old_anf)::date - 1,
                        coalesce(new_anf, old_anf)::date + 1,
                        coalesce(new_minr, old_minr)::varchar
       );
    END IF;

    -- Zusatz beim Update
    IF TG_OP = 'UPDATE' THEN
        -- Stempelung des MA um Tage verschoben
        IF     new_minr = old_minr
           AND new_anf::date <> old_anf::date
           AND _do_recalc
        THEN
            -- Alten Bereich des MA neu berechnen.
            PERFORM tpersonal.mitpln__saldo__recalc__prsz_neu(
                                old_anf::date - 1,
                                old_anf::date + 1,
                                new_minr::varchar
            );

        -- Stempelung zu anderen MA
        ELSIF new_minr <> old_minr THEN
            -- Alten Bereich des alten MA neu berechnen.
            PERFORM tpersonal.mitpln__saldo__recalc__prsz_neu(
                                old_anf::date - 1,
                                old_anf::date + 1,
                                old_minr::varchar
            );
        END IF;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdep__a_10_iud__individwt
    AFTER INSERT  OR DELETE OR UPDATE
    OF bd_anf, bd_end, bd_minr
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__a_10_iud__individwt();
--

-- Präsenzzeit: Validierung; Berechnung: Rundung, Karenz, Pausen; Übergabe an Mitarbeiterplan
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Stempeln
-- !!!!! TRIGGER UNTER: !!!!!!!
-- \0300 Functions\bde\bdep__b_20_iu.sql
-- => bdep__b_20_iu
CREATE FUNCTION bdep__b_20_iu() RETURNS TRIGGER AS $$
  BEGIN
    -- \0300 Functions\bde\bdep__b_20_iu.sql
    RETURN new;
  END $$ LANGUAGE plpgsql;

  -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Stempeln
  CREATE TRIGGER bdep__b_20_iu
    BEFORE INSERT OR UPDATE
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__b_20_iu();
--

-- Überstunden- und Mindestpausenberechnung
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Stempeln
CREATE FUNCTION bdep__a_iu() RETURNS TRIGGER AS $$
  BEGIN
    -- \0300 Functions\bde\bdep__a_iu.sql
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdep__a_iu
    AFTER INSERT OR UPDATE
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__a_iu();

--
CREATE OR REPLACE FUNCTION bdep__b_iu__terminal() RETURNS TRIGGER AS $$
  BEGIN
    new.bd_terminal:= (COALESCE(new.bd_terminal || ';', '') || inet_client_addr()::VARCHAR)::VARCHAR(150);

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdep__b_iu__terminal
    BEFORE INSERT OR UPDATE
    OF bd_anf, bd_end
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__b_iu__terminal();
--

--

-- Beim Löschen von Stempelungen die Zeiten aus dem Zeitkonto rausnehmen
CREATE OR REPLACE FUNCTION bdep__a_d() RETURNS TRIGGER AS $$
  BEGIN
    IF NOT check_valid_bde_date(old.bd_minr, old.bd_individwt_mpl_date) THEN
        RAISE EXCEPTION 'date in past: delete bdep MitNr:%, Date:%', old.bd_minr, old.bd_individwt_mpl_date; -- verwerfen, das ist bereits verbucht
    END IF;

    PERFORM tpersonal.mitpln__saldo__recalc__prsz_neu(old.bd_anf::DATE, old.bd_anf::DATE, old.bd_minr::VARCHAR);

    RETURN old;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdep__a_d
    AFTER DELETE
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__a_d();
--

-- Abwesend automatisch an und ab stempeln wenn mit Abwesenheit abgestempelt
CREATE OR REPLACE FUNCTION bdep__a_u() RETURNS TRIGGER AS $$
  BEGIN
    IF current_user = 'syncro' THEN
        RETURN new;
    END IF;

    IF      new.bd_end IS NOT NULL
        AND old.bd_end IS NULL
        AND new.bd_aus_id IS NOT NULL
        -- Ausfallgrund 110 ist Präsenzzeit-Pause. Das darf keinen Eintrag in Abwesenheiten erzeugen.
        AND new.bd_aus_id <> 110
    THEN
        -- Urlaub
        IF new.bd_aus_id = 1 THEN
            -- Urlaub, das wird erst ab morgen
            INSERT INTO bdepab (bdab_minr,    bdab_aus_id,    bdab_anf)
            VALUES             (new.bd_minr,  new.bd_aus_id,  new.bd_individwt_mpl_date + 1);

        -- für Zeitgutschriften, wie Dienstgang 7034
        -- Dienstgang starten -> Dienstgang Ende bdep__a_i
        -- Zeitgutschriften nach Nachtschichten (an anderem ind. Werktag) nicht implementiert
        ELSIF bdeabgruende__Gutschrift_Is(new.bd_aus_id) THEN
            INSERT INTO bdepab (bdab_minr,    bdab_aus_id,    bdab_anf,         bdab_anft,              bdab_bd_id_anf)
            VALUES             (new.bd_minr,  new.bd_aus_id,  new.bd_end::DATE, new.bd_end_rund::TIME,  new.bd_id);

        -- Alle anderen Abwesenheiten zählen ab sofort.
        ELSE
            INSERT INTO bdepab (bdab_minr,    bdab_aus_id,    bdab_anf)
            VALUES             (new.bd_minr,  new.bd_aus_id,  new.bd_individwt_mpl_date);
        END IF;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdep__a_u
    AFTER UPDATE
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__a_u();
--

-- Dienstreisekorrektur: wenn die Präsenzzeit angepasst wurde, auch die Dienstreisezeit anpassen #7034
-- PZ End -> DG Anf  |  PZ Anf -> DG End
CREATE OR REPLACE FUNCTION bdep__a_u_abw() RETURNS TRIGGER AS $$
  DECLARE  bdidanf INTEGER;
           bdidend INTEGER;
  BEGIN
    --Endezeit Präseneit wird angepasst 'Gehen' ~ Anfangszeit des Dienstgangs anpassen; Gutschrift neu berechnen
    IF (new.bd_end IS DISTINCT FROM old.bd_end) AND (old.bd_end IS NOT NULL) THEN
        UPDATE bdepab
           SET bdab_anft = new.bd_end_rund::TIME, bdab_stu = timediff(new.bd_end_rund::TIME, bdab_endt)
         WHERE bdab_bd_id_anf = new.bd_id AND bdab_minr = new.bd_minr;
    END IF;
    --Anfangszeit Präsenzzeit wird angepasst 'Kommen' ~ Endezeit des Dienstgangs anpassen; Gutschrift neu berechnen
    IF (new.bd_anf IS DISTINCT FROM old.bd_anf) AND (old.bd_anf IS NOT NULL) THEN
        UPDATE bdepab
           SET bdab_endt = new.bd_anf_rund::TIME, bdab_stu = timediff(bdab_anft, new.bd_anf_rund::TIME)
         WHERE bdab_bd_id_end = new.bd_id AND bdab_minr = new.bd_minr;
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdep__a_u_abw
    AFTER UPDATE
    OF bd_anf, bd_end
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__a_u_abw();
--

--
CREATE OR REPLACE FUNCTION bdep__a_i() RETURNS TRIGGER AS $$
  DECLARE abdate DATE;
  BEGIN
    --Dienstgangzeit beenden , wurde gestartet durch bdep__a_u
    --Setze die Endezeit des Dienstgangs und setze die Gutschrift für die Präsenzzeit aus der Zeitdifferenz #7034
    -- Zeitgutschriften nach Nachtschichten (an anderem ind. Werktag) nicht implementiert
    IF EXISTS(SELECT true FROM bdep WHERE bd_minr = new.bd_minr AND bd_anf::DATE = new.bd_anf::DATE AND bd_end IS NOT NULL AND bdeabgruende__Gutschrift_Is(bd_aus_id) ORDER BY bd_anf DESC LIMIT 1) THEN
      UPDATE bdepab SET bdab_endt = new.bd_anf_rund::TIME, bdab_end = new.bd_anf::DATE, bdab_stu = timediff(bdab_anft, new.bd_anf_rund::TIME), bdab_bd_id_end=new.bd_id
        WHERE bdab_minr = new.bd_minr AND bdab_anf = new.bd_anf::DATE AND bdab_endt IS NULL AND bdeabgruende__Gutschrift_Is(bdab_aus_id);
    ELSE
    --Sonstige Abwesenheiten
      UPDATE bdepab SET bdab_end=new.bd_anf::DATE-1 WHERE bdab_minr=new.bd_minr AND bdab_end IS NULL AND bdab_endt IS NULL AND bdab_anf<new.bd_anf::DATE;
      UPDATE bdepab SET bdab_end=new.bd_anf::DATE   WHERE bdab_minr=new.bd_minr AND bdab_end IS NULL AND bdab_endt IS NULL AND bdab_anf=new.bd_anf::DATE;
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdep__a_i
    AFTER INSERT
    ON bdep
    FOR EACH ROW
    EXECUTE PROCEDURE bdep__a_i();
--

-- Bei Fehlstempelung (mehr als 15 h Dauer), aktuelle Anstempelung nachtragen.
-- Verkürzung der Fehlstempelung siehe bdep__b_20_iu.
-- #14106
CREATE OR REPLACE FUNCTION bdep__a_20_iu__insert__bdep__fehlstempelung() RETURNS TRIGGER AS $$
  BEGIN
    -- WHEN (new.bd_end = new.bd_anf + '00:00:01'::TIME)

    -- Wenn die verkürzte Fehlstempelung nicht der letzte Eintrag ist, dann keinen Nachtrag erzeugen und raus.
    IF new.bd_anf <> (SELECT max(bd_anf) FROM bdep WHERE bd_minr = new.bd_minr) THEN  RETURN new;   END IF;

    INSERT INTO bdep(bd_minr, insert_by)
    SELECT new.bd_minr, 'NT'
    WHERE NOT EXISTS(
        SELECT true
        FROM bdep
        WHERE bd_minr = new.bd_minr
          AND bd_end IS NULL
      )
    ;

    RETURN new;
  END $$ LANGUAGE plpgsql;


  CREATE TRIGGER bdep__a_20_iu__insert__bdep__fehlstempelung
    AFTER INSERT OR UPDATE
    OF bd_anf, bd_end, bd_minr
    ON bdep
    FOR EACH ROW
    WHEN (
            (new.bd_end = new.bd_anf + '00:00:01'::TIME)
              -- #16758 Ausnahme für DailyDBFunction: nachts abstempeln, ohne neues Anstempeln
            AND (new.modified_by IS DISTINCT FROM 'NT')
          )
    EXECUTE PROCEDURE public.bdep__a_20_iu__insert__bdep__fehlstempelung();
--

--
CREATE TABLE bdep_log (
  bdl_id                SERIAL,
  bdl_action            VARCHAR(10),
  bdl_anf_alt           TIMESTAMP(0),
  bdl_anf_neu           TIMESTAMP(0),
  bdl_end_alt           TIMESTAMP(0),
  bdl_end_neu           TIMESTAMP(0),
  bdl_minr              INTEGER
);

--
CREATE OR REPLACE FUNCTION bdep_log() RETURNS TRIGGER AS $$
 BEGIN
  IF (tg_op='INSERT')AND(new.bd_anf NOT BETWEEN currenttime()-'00:00:05'::TIME AND currenttime()) THEN
        INSERT INTO bdep_log(bdl_action, bdl_anf_alt, bdl_anf_neu, bdl_end_alt, bdl_end_neu, bdl_minr) VALUES (tg_op, currenttime(), new.bd_anf, NULL, new.bd_end, new.bd_minr);
  END IF;
  IF (tg_op='UPDATE') THEN
        IF new.bd_anf IS DISTINCT FROM old.bd_anf OR (new.bd_end IS DISTINCT FROM old.bd_end AND old.bd_end IS NOT NULL) THEN
                INSERT INTO bdep_log(bdl_action, bdl_anf_alt, bdl_anf_neu, bdl_end_alt, bdl_end_neu, bdl_minr) VALUES (tg_op, old.bd_anf, new.bd_anf, old.bd_end, new.bd_end, new.bd_minr);
        END IF;
  END IF;
  IF tg_op='DELETE' THEN
        INSERT INTO bdep_log(bdl_action, bdl_anf_alt, bdl_end_alt, bdl_minr) VALUES (tg_op, old.bd_anf, old.bd_end, old.bd_minr);
  END IF;
  RETURN old;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER bdep__a_ud_log
 AFTER INSERT OR UPDATE OR DELETE
 ON bdep
 FOR EACH ROW
 EXECUTE PROCEDURE bdep_log();
--

 /*Sonn- und Feiertagsbeschäftigung*/
 CREATE TABLE bdepftbe
  (bdfb_id              serial PRIMARY KEY,
   bdfb_minr            integer NOT NULL REFERENCES llv ON UPDATE CASCADE,
   bdfb_anf             date,
   bdfb_end             date,
   bdfb_akzept          bool, --von Mitarbeiter akzeptiert
   bdfb_bewill          bool, --Bewilligung/Ablehnung
   bdfb_decider         integer NOT NULL REFERENCES llv, --VARCHAR(10) REFERENCES llv(ll_db_usename), --desjenigen der Anfrage gestellt hat
   bdfb_receipt         bool NOT NULL DEFAULT FALSE, --Quittierung //Mitarbeiter muss Feiertagsbeschäftigung als 'zur Kenntnis genommen' quittieren
   bdfb_bem             text, --Bemerkung
   bdfb_bem_rtf         text
  );


 /*Abwesendzeiten-Beantragung*/
 CREATE TABLE bdepabbe
  (bdabb_id             serial PRIMARY KEY,
   bdabb_minr           integer NOT NULL REFERENCES llv ON UPDATE CASCADE,
   bdabb_anfo           date,   --Anfang Beantragung Erstbeantragung ~ wird bei Verschiebung durch den Genehmiger gesetzt
   bdabb_endo           date,   --Ende Beantragung Erstbeantragung
   bdabb_anfto          time(0) without time zone,
   bdabb_endto          time(0) without time zone,
   bdabb_anf            date NOT NULL,
   bdabb_end            date NOT NULL,
   bdabb_anft           time(0) without time zone,--Beginn der Abwesenheit, wenn kein voller Tag
   bdabb_endt           time(0) without time zone,--Beginn der Abwesenheit, wenn kein voller Tag
   bdabb_stu            numeric, --Stunden, wenn kein voller Tag
   bdabb_aus_id         integer NOT NULL REFERENCES bdeabgruende,
   bdabb_bewill_vorl    bool NOT NULL DEFAULT FALSE, --Bewilligung vorläufig > mehrstufige Genehmigung #https://redmine.prodat-sql.de/issues/16431
   bdabb_bewill         bool NOT NULL DEFAULT FALSE, --Bewilligung
   bdabb_ablehn         bool NOT NULL DEFAULT FALSE, --Ablehnung
   bdabb_decider        varchar(10) REFERENCES llv(ll_db_usename) ON UPDATE CASCADE, --desjenigen der Entscheidung trifft
   bdabb_receipt        bool NOT NULL DEFAULT FALSE, --Quittierung //Mitarbeiter muss Abwesenheiten als 'zur Kenntnis genommen' quittieren
   bdabb_bem            text,--Bemerkung
   bdabb_bem_rtf        text,
   CONSTRAINT xtt5037 CHECK(bdabb_end IS NULL OR bdabb_anf<=bdabb_end)
  );

  CREATE INDEX bdepabbe_aus_id ON bdepabbe(bdabb_aus_id) WHERE bdabb_aus_id IS NOT null;


CREATE OR REPLACE FUNCTION bdepabbe__b_iu() RETURNS TRIGGER AS $$
  BEGIN
    IF EXISTS
      ( SELECT TRUE FROM bdepabbe
        WHERE
              new.bdabb_minr = bdabb_minr
          AND new.bdabb_id <> bdabb_id
          AND (
                (
                  (new.bdabb_anf, new.bdabb_end + 1) OVERLAPS (bdabb_anf, bdabb_end + 1) -- Zeitraum überschneidet sich / jeweils Ende + 1, da OVERLAPS rechtsoffenes Intervall ist.
                  AND NOT bdabb_ablehn   -- Wenn abgelehnt, dann kann man für einen alternativen Zeitraum beantragen ~ Letzte Änderung #20680
                )
                OR
                (
                      (new.bdabb_anf = bdabb_anf)
                  AND (new.bdabb_end = bdabb_end) -- der Zeitraum darf aber nicht exakt der Gleiche sein, wie ein bereits bestehender Antrag, unabhägig vom Genehmigungsstatusn
                )
              )
      ) THEN
          RAISE EXCEPTION 'bdepabbde already exists in range. xtt15856'; --Eine Abwesenheitsbeantragung für diesen Zeitraum existiert bereits.
    END IF;
    --
    IF (SELECT ab_autobewill FROM bdeabgruende WHERE ab_id = new.bdabb_aus_id) THEN  --Wenn Auto-Genehmigen-Status gesetzt ist, sofort genehmigen
        new.bdabb_bewill := TRUE;
    END IF;

    -- Urlaub hat NIE Uhrzeiten! Es gibt Urlaub 1 Tag oder Ulaub 1/2 tag als Abwesenheitsgrund
    IF new.bdabb_aus_id IN (1, 100) THEN -- Urlaub in Stunden wird basierend auf dem Tagesplan errechnet. Auch da hat die Uhrzeit nichts zu suchen!
       new.bdabb_anft := null;
       new.bdabb_endt := null;
    END IF;

    --
    IF tg_op='UPDATE' THEN
        IF new.bdabb_anf IS DISTINCT FROM old.bdabb_anf AND new.bdabb_anfo IS NULL THEN
            new.bdabb_anfo:=old.bdabb_anf;
        END IF;
        --
        IF new.bdabb_end IS DISTINCT FROM old.bdabb_end AND new.bdabb_endo IS NULL THEN
            new.bdabb_endo:=old.bdabb_end;
        END IF;
        --
        IF new.bdabb_anft IS DISTINCT FROM old.bdabb_anft AND new.bdabb_anfto IS NULL THEN
            new.bdabb_anfto:=old.bdabb_anfto;
        END IF;
        --
        IF new.bdabb_endt IS DISTINCT FROM old.bdabb_endt AND new.bdabb_endto IS NULL THEN
            new.bdabb_endto:=old.bdabb_endt;
        END IF;
    END IF;
    --

    RETURN new;
  END $$ LANGUAGE plpgsql;


  CREATE TRIGGER bdepabbe__b_iu
    BEFORE INSERT OR UPDATE
    ON bdepabbe
    FOR EACH ROW
    EXECUTE PROCEDURE bdepabbe__b_iu();
--


/* Entscheider setzen von Genehmigungen und Abweisung von Abwesenheitszeiten*/
 CREATE OR REPLACE FUNCTION bdepabbe__b_u_bewa() RETURNS TRIGGER AS $$  -- before update bewilligung ablehnung
 BEGIN
  IF new.bdabb_bewill OR new.bdabb_ablehn THEN
        new.bdabb_decider:=current_user;
  END IF;
  RETURN new;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER bdepabbe__b_u_bewa
 BEFORE UPDATE OF bdabb_bewill, bdabb_ablehn
 ON bdepabbe
 FOR EACH ROW
 EXECUTE PROCEDURE bdepabbe__b_u_bewa();


/* Kopierfunktionen zwischen Beantragung und Genehmigungen von Abwesenheitszeiten*/
 CREATE OR REPLACE FUNCTION bdepabbe__a_iu_bewa() RETURNS TRIGGER AS $$  -- after update bewilligung ablehnung // bdab_anft und bdab_endt ungeklärt
 BEGIN
  -- Für Bewilligung
  IF new.bdabb_bewill AND NOT new.bdabb_ablehn THEN
        INSERT INTO bdepab (bdab_bdabb_id, bdab_anf, bdab_anft, bdab_end, bdab_endt, bdab_minr, bdab_aus_id, bdab_stu, bdab_bem, bdab_decider, bdab_decision_date)
        VALUES             (new.bdabb_id, new.bdabb_anf, new.bdabb_anft, new.bdabb_end, new.bdabb_endt, new.bdabb_minr, new.bdabb_aus_id, new.bdabb_stu, new.bdabb_bem, new.bdabb_decider, current_date);
  END IF;
  --
  IF new.bdabb_ablehn THEN
        DELETE FROM bdepab WHERE bdab_bdabb_id=new.bdabb_id;
  END IF;
  RETURN new;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER bdepabbe__a_iu_bewa
 AFTER INSERT OR UPDATE OF bdabb_bewill, bdabb_ablehn
 ON bdepabbe
 FOR EACH ROW
 EXECUTE PROCEDURE bdepabbe__a_iu_bewa();
--

-- Abwesendzeiten
CREATE TABLE bdepab (
  bdab_id               SERIAL          PRIMARY KEY,
  bdab_minr             integer         NOT NULL REFERENCES llv ON UPDATE CASCADE DEFERRABLE INITIALLY DEFERRED, -- DEFERRED: fKey-CASCADE muss zum Schluss ausgeführt werden, sonst wird mitpln-Eintrag (TriggeR) erzeugt, der in Konflikt mit dem fKey-CASCADE steht.
  bdab_anf              date            NOT NULL DEFAULT current_date,
  bdab_anft             time(0) without time zone, --für Raucherpause
  bdab_end              date,
  bdab_endt             time(0) without time zone, --für Raucherpause
  bdab_stu              numeric,
  bdab_aus_id           integer         REFERENCES bdeabgruende,
  bdab_buch             bool            NOT NULL DEFAULT FALSE,
  bdab_bdabb_id         integer         REFERENCES bdepabbe, --Abwesenheit ist beantragt und freigegeben -> Ursprungsdatensatz; ACHTUNG im DELETE TRIGGER wird das nochmal umgangen!
  bdab_bd_id_anf        integer,        --REFERENCES bdep
  bdab_bd_id_end        integer,
  bdab_bem              text,           --Bemerkung
  bdabb_bem_rtf         text,
  bdab_decider          varchar(10)     DEFAULT tsystem.current_user_ll_db_usename() REFERENCES llv(ll_db_usename) ON UPDATE CASCADE, -- #18109 Entscheider für Abwesenheit
  bdab_decision_date    date DEFAULT current_date, -- #18109
  CONSTRAINT xtt5037 CHECK(bdab_end IS NULL OR bdab_anf <= bdab_end),
  CONSTRAINT bdepab_bdab_buch_incomplete
       CHECK ( bdab_buch IS false
              OR
               (-- Uhrzeiten Anfang und Ende leer oder beide gefüllt. Keine "Halbe Sache" wenn verbucht wird
                (   (bdab_anft IS     null AND bdab_endt IS     null)
                 OR (bdab_anft IS NOT null AND bdab_endt IS NOT null)
                 )
                 -- Anfang und Ende (Datum) muss korrekt gesetzt sein!
                AND
                (bdab_anf IS NOT null AND bdab_end IS NOT null)
               )
              )
  );

CREATE INDEX bdepab_dat_minr  ON bdepab(bdab_minr, bdab_anf, bdab_end);
CREATE INDEX bdepab_anf_end   ON bdepab(bdab_anf, bdab_end);
CREATE INDEX bdepab_buch_minr ON bdepab(bdab_minr) WHERE NOT bdab_buch; -- unverbuchte Datensätze werden häufig abgefragt
CREATE INDEX bdepab_bdabb_id  ON bdepab(bdab_bdabb_id) WHERE bdab_bdabb_id IS NOT null;

-- Trigger der automatisch die Sätze in der mitpln für Abwesendtage führt
CREATE OR REPLACE FUNCTION bdepab__b_iu() RETURNS TRIGGER AS $$
  DECLARE fts RECORD;
          bdabend DATE;
          --NULLANF TIME(0);
          --NULLEND TIME(0);
          i INTEGER;
          error_info VARCHAR;
  BEGIN
    IF current_user = 'syncro' OR new.bdab_buch THEN
        RETURN new;
    END IF;

    -- ursprl. Datensatzinfo, die in den Fehlermeldungen verwendet wird: Mitarbeiter, Anfang, Ende, Abwesenheit
    error_info := concat(E'\n\n', lang_text(5036), ': ', new.bdab_minr,
        E'\n', lang_text(221), ': ', new.bdab_anf, E'\n', lang_text(365), ': ', new.bdab_end,
        E'\n', lang_text(259), ': ', new.bdab_aus_id, ' ', (SELECT ab_txt FROM bdeabgruende WHERE ab_id = new.bdab_aus_id));

    -- Eingabefehler
    IF new.bdab_anf > new.bdab_end THEN
        -- Eingabefehler bei Abwesenheit! Anfang liegt vor Ende.
        RAISE EXCEPTION '%', lang_text(16444) || error_info;
    END IF;

    IF new.bdab_aus_id = 103 THEN -- Raucherpause (Zeit wird erst beim Monatsabschluss eingerechnet)
        new.bdab_stu := 0;
    END IF;

    -- Urlaub hat NIE Uhrzeiten! Es gibt Urlaub 1 Tag oder Ulaub 1/2 tag als Abwesenheitsgrund
    IF new.bdab_aus_id IN (1, 100) THEN -- Urlaub in Stunden wird basierend auf dem Tagesplan errechnet. Auch da hat die Uhrzeit nichts zu suchen!
       new.bdab_anft := null;
       new.bdab_endt := null;
    END IF;

    IF TG_OP = 'INSERT' THEN
        IF NOT check_valid_bde_date(new.bdab_minr, new.bdab_anf) THEN
            -- Eintrag der Abwesenheit in bereits verbuchtem Monat nicht möglich.
            RAISE EXCEPTION '%', lang_text(16445) || error_info;
        END IF;
        -- nun beim INSERT die Vorgabestunden holen
        IF new.bdab_stu IS NULL THEN
            new.bdab_stu:=ab_stu FROM bdeabgruende WHERE ab_id=new.bdab_aus_id;
        END IF;
    END If;
    IF TG_OP <> 'INSERT' THEN
        IF old.bdab_buch THEN IF NOT new.bdab_buch THEN RETURN new; ELSE RETURN old; END IF; END IF; -- Satz festmachen
        IF new.bdab_buch THEN RETURN new; END IF;
    END IF;

    -- Verschiebungen gemäß Feiertage
    IF new.bdab_anf <> new.bdab_end THEN
        -- Anfang weiter in Zukunft schieben, bis kein Feiertag erreicht wird.
        WHILE (new.bdab_aus_id IN (1, 100) AND EXISTS(SELECT true FROM feiertag WHERE ft_date=new.bdab_anf AND NOT ft_urlaub)) -- genau auf den Feiertag den Anfang gelegt, verwerfen und einen Tag später neu
              OR (EXISTS(SELECT true FROM feiertag WHERE ft_date=new.bdab_anf AND ft_urlaub)) -- dito Betriebsurlaub
        LOOP
            new.bdab_anf:=new.bdab_anf+1;
        END LOOP;

        -- Ende vorziehen, bis kein Feiertag erreicht wird.
        WHILE (new.bdab_aus_id IN (1, 100) AND EXISTS(SELECT true FROM feiertag WHERE ft_date=new.bdab_end AND NOT ft_urlaub)) -- genau auf den Feiertag den Anfamg gelegt, verwerfen und einen Tag später neu
              OR (EXISTS(SELECT true FROM feiertag WHERE ft_date=new.bdab_end AND ft_urlaub)) -- dito Betriebsurlaub
        LOOP
            new.bdab_end:=new.bdab_end-1;
        END LOOP;
    END IF;

    -- Ergebnis nach Verschiebung unsinnig (z.B. Urlaub lag komplett innerhalb von Feiertagen)
    IF new.bdab_anf > new.bdab_end THEN
        RAISE EXCEPTION '%', lang_text(16446) || error_info;
    END IF;

    -- darf nicht über Monatsende hinaus gehen um beim Verbuchen Fehler zu vermeiden
    IF extract(month FROM new.bdab_anf) <> extract(month FROM new.bdab_end) THEN
        -- aktuelle bdepab auf Ende Monat, neue bdepab für nächsten Monat einbauen
        IF current_user='root' THEN
            RAISE NOTICE 'end of month: minr: %, ausid: %, date % - %', new.bdab_minr, new.bdab_aus_id, new.bdab_anf, new.bdab_end;
        END IF;


        bdabend:=new.bdab_end;
        new.bdab_end:=date_trunc('month', new.bdab_anf + '1 month'::INTERVAL)::DATE - 1;
        -- ist rekursiv, wenn wieder ein Monat auseinander
        INSERT INTO bdepab (bdab_minr, bdab_anf, bdab_end, bdab_stu, bdab_aus_id, bdab_buch, bdab_bdabb_id)
        SELECT new.bdab_minr, date_trunc('month', new.bdab_anf + '1 month'::INTERVAL)::DATE, bdabend, new.bdab_stu, new.bdab_aus_id, new.bdab_buch, new.bdab_bdabb_id;
    END IF;

    /* #7034 Gutschrift errechnen bei manueller Eingabe OHNE Kommen/Gehen für Dienstgang SOWIE wenn der Mitarbeiter mit Dienstgang geht und nicht wieder kommt und Automatismus mit Tagesplan-Ende abstempeln aktiv
       Zwecks Usability wäre auch Oberflächen Refresh notwendig um Änderung zu sehen     */
    IF bdeabgruende__Gutschrift_Is(new.bdab_aus_id)
      AND (new.bdab_anft IS NOT NULL AND new.bdab_endt IS NOT NULL) --Nur wenn Zeiten gesetzt sind
      AND (new.bdab_bd_id_end IS NULL) --die IDs werden übergeben, wenn über Gehen/Kommen, Dienstgang an/abgestempelt wird; nur wenn manuell nachträglich eingetragen wird, ändern
    THEN

        -- Ergänzung um Datum für Ticket #14769, da Pausen über Mitternacht sonst zu Fehlern führen
        new.bdab_stu :=
            timediff(
                -- Anfangsdatum + zeit
                new.bdab_anf + new.bdab_anft,

                -- Endedatum + zeit, Fallback Anfangsdatum
                coalesce (
                    new.bdab_end,
                    new.bdab_anf
                ) + new.bdab_endt
            )
        ;

    END IF;

    -- Identischer Abwesenheitsgrund im angegebenen Zeitraum vorhanden, Dienstgang mehrfach zulassen #7034
    IF (new.bdab_aus_id <> 103) AND NOT bdeabgruende__Gutschrift_Is(new.bdab_aus_id) THEN
        ---- aktuell wird nur auf den ganzen Tag geprüft
        ---- mehrere stundenweise Abwesenheiten am selben Tag so nicht möglich
        ---- daher ist aktuell die Raucherpause von dieser Prüfung ausgeschlossen
        --NULLANF := '00:00:00'::TIME(0);
        --NULLEND := '23:59:59'::TIME(0);
        --IF EXISTS(SELECT true FROM bdepab WHERE bdab_id <> new.bdab_id AND bdab_minr = new.bdab_minr AND bdab_aus_id = new.bdab_aus_id
        --        AND (bdab_anf+COALESCE(bdab_anft,NULLANF) BETWEEN new.bdab_anf+COALESCE(new.bdab_anft,NULLANF) AND new.bdab_end+COALESCE(new.bdab_endt,NULLEND)
        --          OR bdab_end+COALESCE(bdab_endt,NULLEND) BETWEEN new.bdab_anf+COALESCE(new.bdab_anft,NULLANF) AND new.bdab_end+COALESCE(new.bdab_endt,NULLEND)
        --          OR (bdab_anf+COALESCE(bdab_anft,NULLANF) < new.bdab_anf+COALESCE(new.bdab_anft,NULLANF)
        --          AND bdab_end+COALESCE(bdab_endt,NULLEND) > new.bdab_end+COALESCE(new.bdab_endt,NULLEND))) LIMIT 1) THEN
        IF EXISTS(SELECT true FROM bdepab
                   WHERE bdab_id <> new.bdab_id
                     AND bdab_minr = new.bdab_minr
                     AND bdab_aus_id = new.bdab_aus_id
                     AND (   bdab_anf BETWEEN new.bdab_anf AND new.bdab_end
                          OR bdab_end BETWEEN new.bdab_anf AND new.bdab_end
                          OR (    bdab_anf < new.bdab_anf
                              AND bdab_end > new.bdab_end
                              )
                          ) LIMIT 1
                  )
        THEN
            RAISE EXCEPTION 'duplicate bdepab %', lang_text(16447) || error_info;
        END IF;
    END IF;

    -- für diese Tage fehlende Tagespläne hinterlegen (nur vergangene Mo-Fr)
    IF new.bdab_end IS NOT NULL THEN
        FOR i IN 0 .. new.bdab_end-new.bdab_anf AS DATE LOOP
            --Tagespläne nicht mehr in die Zukunft eintragen. Das passiert automatisch am Tag der Stempelung
            --Hintergrund: Änderung von Tagesplan oder Schichtmodellen. Ticket #1963
            IF new.bdab_anf + i < current_date AND EXTRACT(dow FROM new.bdab_anf + i) BETWEEN 1 AND 5 THEN
                INSERT INTO mitpln (mpl_date, mpl_minr)
                     SELECT new.bdab_anf + i, new.bdab_minr
                      WHERE NOT EXISTS(SELECT true FROM mitpln
                                        WHERE mpl_date = new.bdab_anf + i
                                          AND mpl_minr = new.bdab_minr
                                       );
            END IF;
        END LOOP;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdepab__b_iu
    BEFORE INSERT OR UPDATE
    ON bdepab
    FOR EACH ROW
    EXECUTE PROCEDURE bdepab__b_iu();
--

--
CREATE OR REPLACE FUNCTION bdepab__a_10_iud() RETURNS TRIGGER AS $$
  DECLARE
      fts               record;
      _abwesenheit_txt  varchar;
  BEGIN

    -- INSERT, UPDATE
    IF TG_OP <> 'DELETE' THEN

        -- Urlaub und Krank aufteilen entspr. der Feiertage.
        IF COALESCE(new.bdab_aus_id, 0) IN (1, 2) THEN -- Urlaub und Krank
            -- Feiertage die in die Zeit des Urlaubs fallen
            FOR fts IN SELECT * FROM feiertag WHERE ft_date BETWEEN new.bdab_anf AND new.bdab_end AND NOT ft_urlaub LOOP
                -- Urlaub ist genau am Feiertag
                IF new.bdab_anf = new.bdab_end AND fts.ft_date = new.bdab_anf THEN
                    DELETE FROM bdepab WHERE dbrid = new.dbrid;
                END IF;
                -- Anfang genau auf Feiertag gelegt
                IF new.bdab_anf = fts.ft_date AND new.bdab_end > fts.ft_date THEN
                    UPDATE bdepab SET bdab_anf = fts.ft_date+1 WHERE dbrid = new.dbrid;--wir unterbrechen Urlaub, Krank usw.
                END IF;
                -- Ende genau auf Feiertag gelegt
                IF new.bdab_end = fts.ft_date AND new.bdab_anf < fts.ft_date THEN
                    UPDATE bdepab SET bdab_end = fts.ft_date-1 WHERE dbrid = new.dbrid;--wir unterbrechen Urlaub, Krank usw.
                END IF;
                -- Feiertag genau in der Mitte, Abwesenheit splitten
                -- Abwesenheit über Monatswechsel: wird in bdepab__b_iu auseinandergezogen
                IF new.bdab_anf < fts.ft_date AND new.bdab_end > fts.ft_date THEN -- wir tragen nach dem Feiertag das Zeug wieder ein.
                    UPDATE bdepab SET bdab_end = fts.ft_date-1 WHERE dbrid = new.dbrid AND bdab_anf < fts.ft_date; -- splitten
                    IF fts.ft_date < new.bdab_end THEN
                        INSERT INTO bdepab (bdab_anf, bdab_end, bdab_minr, bdab_stu, bdab_aus_id, bdab_bdabb_id) VALUES (fts.ft_date+1, new.bdab_end, new.bdab_minr, new.bdab_stu, new.bdab_aus_id, new.bdab_bdabb_id);
                    END IF;
                    UPDATE mitpln SET mpl_feiertag = fts.ft_bez WHERE mpl_date = fts.ft_date AND mpl_minr = new.bdab_minr AND NOT mpl_buch;
                END IF;

                DELETE FROM bdepab WHERE bdab_anf = bdab_end AND bdab_anf = fts.ft_date AND bdab_minr = new.bdab_minr; --f alls er nur an dem Tag war, löschen wir den Urlaub, Krank.
                -- Da das UPDATE und INSERT selbst wieder diesen Trigger aufruft, hören wir hier auf, damit die Schleife nicht 10* durchläuft.
                RETURN new;
            END LOOP;
        END IF;


        RETURN new;

    END IF;


    -- DELETE
    IF TG_OP = 'DELETE' THEN

        -- Löschen validieren. Bereits verbuchte Abwesenheiten dürfen nicht gelöscht werden.
        IF NOT check_valid_bde_date( old.bdab_minr, old.bdab_anf ) THEN

            _abwesenheit_txt := ab_txt FROM bdeabgruende WHERE ab_id = old.bdab_aus_id;

            -- Verwerfen. Das ist bereits verbucht.
            RAISE EXCEPTION '%',
                concat_ws(
                    E'\n',
                    lang_text(16140)  || E'\n',
                    lang_text(5036)   || ': ' || old.bdab_minr,
                    lang_text(221)    || ': ' || old.bdab_anf,
                    lang_text(365)    || ': ' || old.bdab_end,
                    lang_text(259)    || ': ' || coalesce( _abwesenheit_txt, '?')
                )
            ;

        END IF;


        RETURN old;

    END IF;

  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdepab__a_10_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON bdepab
    FOR EACH ROW
    EXECUTE PROCEDURE bdepab__a_10_iud();
--

/* Setzen von Genehmigenden Mitarbeitern und dazugehörigem Datum
es werden nur die relevanten Felder (OF) als bewusste Änderung von Entscheidern betrachtet, die im Zweifel die ursprüngliche Freigabe durch die Beantragung anpassen
eine Änderung dieser Felder gilt definitionsgemäß als neue Entscheidung, weshalb auch das Datum der Entscheidung geändert wird (und nicht mehr der ursprünglichen Freigabe der Beantragung entsprechen muss)
*/
CREATE OR REPLACE FUNCTION bdepab__a_40_u__decider() RETURNS TRIGGER AS $$
  BEGIN
    --
    IF NOT new.bdab_buch THEN -- Wenn verbucht ist, ergibt es wenig Sinn den Genehmigenden umzuschreiben

        new.bdab_decider       := current_user;
        new.bdab_decision_date := current_date;

        RETURN new;
    END IF;

    RETURN old;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdepab__a_40_u__decider
    AFTER UPDATE
    OF bdab_minr, bdab_anf, bdab_end, bdab_aus_id
    ON bdepab
    FOR EACH ROW
    WHEN (old.bdab_aus_id NOT IN (101, 103, 110))   -- Pausen-Abwesenheiten sollen nicht berücksichtigt werden
    EXECUTE PROCEDURE bdepab__a_40_u__decider();
--


-- Nach Löschen Bewilligung rückgängig; Quittierung aufheben.
CREATE OR REPLACE FUNCTION bdepab__a_50_d() RETURNS TRIGGER AS $$
  DECLARE rows INTEGER;
  BEGIN
    IF tg_op='DELETE' THEN --war schon genehmigt, wird rückgängig gemacht
        UPDATE bdepabbe SET bdabb_ablehn=TRUE, bdabb_receipt=False WHERE bdabb_id = old.bdab_bdabb_id;
        GET DIAGNOSTICS rows = ROW_COUNT;
        IF rows>0 THEN
            PERFORM PRODAT_TEXT(11805);
        END IF;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdepab__a_50_d
    AFTER DELETE
    ON bdepab
    FOR EACH ROW
    EXECUTE PROCEDURE bdepab__a_50_d();
--

--
CREATE OR REPLACE FUNCTION bdepab__a_90_iud__prsz_recalc() RETURNS TRIGGER AS $$
  DECLARE
      _new_bdepab       bdepab; -- new-Daten der Abwesenheit

      _id_mindestpause  CONSTANT integer := 101; -- feste ID der Mindestpause
      _id_raucherpause  CONSTANT integer := 103; -- feste ID der Raucherpause
  BEGIN
    -- Automatische Neuberechnung der BDE-Daten bei Eintragungen und Änderungen von Abwesenheiten.


    -- new-Block: Neuberechnung der Tage im Bereich der aktuellen Änderungen.
    IF TG_OP IN ( 'INSERT', 'UPDATE' ) THEN

        IF
            -- Eintrag mit Verbuchung und Änderungen inkl. Verbuchung ausschließen.
                new.bdab_buch IS false

            -- Diese Abwesenheiten haben keinen Effekt.
            -- Insb. Mindestpause ist ein automatischer Eintrag und muss ignoriert werden, sonst Trigger-Loop.
            AND new.bdab_aus_id NOT IN ( _id_mindestpause, _id_raucherpause )

        THEN

            PERFORM tpersonal.mitpln__saldo__recalc__prsz_neu( new.bdab_anf, new.bdab_end, new.bdab_minr::varchar );

        END IF;

        -- new-Daten im old-Block zur Verfügung stellen.
        _new_bdepab := new WHERE TG_OP = 'UPDATE';

    END IF;


    -- old-Block: Neuberechnung der Tage im Bereich vor den Änderungen.
    IF TG_OP IN ( 'UPDATE', 'DELETE' ) THEN

        -- Default für DELETE-Fall
        _new_bdepab.bdab_buch := coalesce( _new_bdepab.bdab_buch, false );

        IF
            -- Setzen auf Verbuchung darf alten Bereich nicht neu berechnen
                _new_bdepab.bdab_buch IS false

            -- Änderungen an und Löschen von verbuchten Einträge ausschließen.
            AND old.bdab_buch IS false

            -- Diese Abwesenheiten hatten vorher keinen Effekt. Der alte Bereich darf nicht neu berechnet werden.
            -- Insb. Mindestpause ist ein automatischer Eintrag und muss ignoriert werden, sonst Trigger-Loop.
            AND old.bdab_aus_id NOT IN ( _id_mindestpause, _id_raucherpause )

            -- Nur bei diesen geänderten Daten den alten Bereich neu berechnen.
            -- Änderung der Zeiten (anft, endt, stu) und Aufhebung der Verbuchung sind bereits im new-Block verarbeitet.
            AND
                row( old.bdab_minr,         old.bdab_anf,         old.bdab_end,         old.bdab_aus_id )
                IS DISTINCT FROM
                row( _new_bdepab.bdab_minr, _new_bdepab.bdab_anf, _new_bdepab.bdab_end, _new_bdepab.bdab_aus_id )

        THEN

            PERFORM tpersonal.mitpln__saldo__recalc__prsz_neu( old.bdab_anf, old.bdab_end, old.bdab_minr::varchar );

        END IF;

    END IF;


    -- return-Block
    IF TG_OP IN ( 'INSERT', 'UPDATE' ) THEN
        RETURN new;
    ELSE  -- DELETE
        RETURN old;
    END IF;

  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdepab__a_90_iud__prsz_recalc
    AFTER INSERT OR DELETE OR UPDATE
    OF bdab_minr, bdab_anf, bdab_anft, bdab_end, bdab_endt, bdab_stu, bdab_aus_id
    ON bdepab
    FOR EACH ROW
    EXECUTE PROCEDURE bdepab__a_90_iud__prsz_recalc();
--


-- BDEA steht für Betriebsdatenerfassung: Auftragszeit
CREATE TABLE bdea (
  ba_id                  serial PRIMARY KEY,
  ba_minr                integer REFERENCES llv ON UPDATE CASCADE,                      -- Mitarbeiter-Nr.
  ba_anf                 timestamp(0) without time zone NOT null DEFAULT currenttime(), -- Start der Auftragszeit
  ba_end                 timestamp(0) without time zone,                                -- Ende  der Auftragszeit
  ba_anf_rund            timestamp(0) without time zone,                                -- Start der Auftragszeit gerundet
  ba_end_rund            timestamp(0) without time zone,                                -- Ende  der Auftragszeit gerundet
  ba_ix                  integer NOT null,                -- ABK-Index
  ba_op                  integer NOT null,                -- ABK-Arbeitsgang (Referenz auf op2.o2_n bzw. ab2.a2_n)
  ba_o2k_id              integer REFERENCES op2kat,       -- Bearbeitungskategorie
  ba_stk                 numeric(12,4),                   -- Menge gefertigt (Stückzahl)
  ba_stk_time            numeric(12,4),                   -- Stückzeit
  ba_efftime_calc_by_stk boolean NOT null,                -- Mehrmaschinenbedienung (effektive Auftragszeit = Stückzahl * Stückzeit)
  ba_auss                numeric(12,4),                                               -- Menge an Ausschuss
  ba_asg_id              integer REFERENCES bdea_ausschussgruende ON UPDATE CASCADE,  -- Grund für Ausschuss
  ba_ks                  varchar(9) NOT null REFERENCES ksv ON UPDATE CASCADE,  -- Kostenstellen (ggf. abweichend zum AG)
  ba_ksap                varchar(25),                                           -- Arbeitsplatz an Kostenstelle
  ba_aus_id              integer CONSTRAINT xtt5050 REFERENCES bdeausgruende,   -- Ausfallgrund (auch Pause/Raucherpause)
  ba_id_interrupt_last   integer REFERENCES bdea ON DELETE CASCADE,    -- #16603 Verweis auf die letzte Stempelung welche durch Pause abgestempelt wurde
  ba_in_rckmeld          boolean NOT null DEFAULT false,  -- Auftragszeit wurde in Rückmeldungen (rm) übernommen
  ba_ende                boolean NOT null DEFAULT false,  -- Auftragszeit beendet ABK-AG
  ba_ruest               boolean NOT null DEFAULT false,  -- Auftragszeit ist Rüstzeit
  ba_pausenab            numeric(12,4), -- Pausenabzug intern in h
  ba_efftime             numeric(12,4), -- effektive Auftragszeit in h (Zeit zwischen Start und Ende)
  --ba_abzug             NUMERIC, -- Abzug bei ABK zusammenfassen die anteile der anderen ABK an der Gesamtzeit
  ba_txt                 text,          -- Hinweis-Text
  ba_resttime            numeric(12,4), -- Info bzgl. aktueller Restarbeiszeit in h
  --ba_stellplatz         VARCHAR(50) DEFAULT NULL,        -- Lagerstellplatz, wo die Ware nach der Stempelung und gefertigte-Mengen-Meldung abgelegt wurde; #8483
  CONSTRAINT xtt5037     CHECK( ba_end IS null OR ba_anf < ba_end ),
  CONSTRAINT xtt16246    CHECK( ba_end IS null OR ( ba_end - ba_anf ) < '31 days'::interval )
);

-- Indizes
  CREATE INDEX bdea_anf ON bdea (timestamp_to_date(ba_anf));
  CREATE INDEX bdea_anf_cast ON bdea ( (ba_anf::date) );
  CREATE INDEX bdea_anf_termweek ON bdea (termweek(ba_anf));
  CREATE INDEX bdea_ks_anf ON bdea (ba_ks, ba_anf);
  CREATE INDEX bdea_end ON bdea (timestamp_to_date(ba_end));
  CREATE INDEX bdea_end_cast ON bdea ( (ba_end::date) );
  CREATE INDEX bdea_ba_ix ON bdea (ba_ix);
  CREATE INDEX bdea_active ON bdea (ba_ks) WHERE ba_efftime IS NULL;
  CREATE INDEX bdea_ende ON bdea(ba_end, ba_ende);
  CREATE INDEX bdea_ba_minr ON bdea(ba_minr);
  CREATE INDEX bdea_ba_minr_like ON bdea(CAST(ba_minr AS varchar) varchar_pattern_ops); -- ClassBDE
--

-- doppeltstemplungen verhinden https://redmine.prodat-sql.de/issues/11714
-- https://ci.prodat-sql.de/sources/tests/suite/10/runner/90
  ALTER TABLE bdea
   ADD CONSTRAINT xtt25476_no_overlap --Eine weitere Stempelung im gleichen Zeitbereich und den gleichen Mitarbeiter ist nicht zulässig.
   EXCLUDE USING gist
      (
        ba_minr WITH =,
        ba_ix WITH =,
        ba_op WITH =,
        ba_ks WITH =,
        tsrange(ba_anf, ba_end, '()') WITH &&
      ) WHERE ( ba_minr IS NOT NULL AND ba_end IS NOT NULL );

--#17574
  ALTER TABLE bdea ADD CONSTRAINT bdea__calc_by_stk__need__stk__and__time
                                             CHECK( ( ( ba_efftime_calc_by_stk = true ) AND ( ba_stk IS NOT null ) AND ( ba_stk_time IS NOT null ) )
                                                 OR ( ( ba_efftime_calc_by_stk = true ) AND ( ba_stk IS null ) )
                                                 OR ( ( ba_efftime_calc_by_stk = false ) )
                                                  );

/*kein Auftrag darf 2-mal auf denselben Mitarbeiter angestempelt werden*/
/*dazu zuerst pruefen ob schon eine Anstempelung da ist, wenn ja, dann EXCEPTION */

CREATE OR REPLACE FUNCTION allow_insert_bdea() RETURNS TRIGGER AS $$
  BEGIN
    IF (new.ba_end IS NULL)AND(new.ba_efftime IS NULL)AND(EXISTS(SELECT true FROM bdea WHERE ba_minr=new.ba_minr AND ba_end IS NULL AND ba_ix=new.ba_ix AND ba_op=new.ba_op AND ba_ks=new.ba_ks AND ba_efftime IS NULL))
        THEN RAISE EXCEPTION 'xtt5034 cannot insert 2nd "BEGIN WORK AUFTG" record';
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER allow_insert_bdea
    BEFORE INSERT
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE allow_insert_bdea();
--

/*erneutes Anstempeln innerhalb einer bestehenden ... siehe oben*/

CREATE OR REPLACE FUNCTION bdea__b_iu() RETURNS trigger AS $$
  DECLARE
      _tplanname       varchar;
      _f               numeric;
      _f2              numeric;
      _check_ba_asg_id boolean;
      _pause           boolean;
  BEGIN
      IF current_user='syncro' THEN
          RETURN new;
      END IF;

      IF
                ks_notstemp
           FROM ksv
          WHERE ks_abt = new.ba_ks
      THEN
          -- wenn Kostenstelle die Einstellung 'in BDE ungültig' besitzt, darf auch nicht gestempelt werden
          RAISE EXCEPTION 'xtt20134 - bdea__b_iu__ksv_ks_notstemp ABK:%, AG:%, KSV:%', new.ba_ix, new.ba_op, new.ba_ks;
      END IF;

      IF
               a2_ausw
          FROM ab2
          WHERE a2_ab_ix = new.ba_ix
            AND a2_n = new.ba_op
      THEN
          -- Auf Auswärtsarbeitsgänge darf keine Auftragszeit gebucht werden. Ergänzen Sie ggf. einen Arbeitsgang.
          RAISE EXCEPTION 'xtt16275 - bdea__b_iu__a2_ausw ABK:%, AG:%', new.ba_ix, new.ba_op;
      END IF;

      -- Zustand für Durchführung der Prüfung bzgl. Pflicht-Ausschussgrund
      IF
          TG_OP = 'INSERT'
      THEN
          _check_ba_asg_id := true;
      ELSE
          -- UPDATE
          -- Beim Abschließen (f -> t) oder bei noch offener (f -> f) Auftragszeit,
          -- aber nicht, wenn geschlossen (t -> t) ist oder geöffnet (t -> f) wird.
          IF
              NOT old.ba_ende
          THEN
              _check_ba_asg_id := true;
          END IF;
      END IF;

      -- Prüfung bzgl. Pflicht-Ausschussgrund
      IF _check_ba_asg_id THEN
          IF
                  TSystem.Settings__GetBool('bdea_GrundIstPflicht')
              AND coalesce( new.ba_auss, 0 ) > 0
              AND new.ba_asg_id IS null
          THEN
              -- Wenn Setting gesetzt und Ausschuss eingegeben, aber kein Ausschussgrund dann Fehlermeldung
              RAISE EXCEPTION 'xtt20126 bdea__b_iu -> Settings"bdea_GrundIstPflicht" AND ba_asg_id IS null';
          END IF;
      END IF;

      -- Ende melden OHNE Zeiten als Zeitnachtrag
      IF     new.ba_end     IS null -- Zeitnachtrag
         AND new.ba_ende    IS true -- Beendet via Zeitnachtrag
         AND new.ba_efftime IS null -- Keine Zeit angegeben. Wir beenden nur den AG
      THEN
            new.ba_efftime := 0;
      END IF;

      -- Wenn Menge angegeben, kann auch ohne Zeit gemeldet werden.
        -- Anwendungsfall und Implementierung unklar und wird weiter unten erneut geprüft.
        -- Ggf. Widerspruch zu bdea__b_iu__efftime_by_stk und ba_efftime_calc_by_stk:
        -- efftime = 0, wenn Flag "auf Stückzeit basierend" aktiv ist und keine Stückzahl oder keine Stückzeit.
        -- funktioniert nur aufgrund Trigger-Reihenfolge
      IF   new.ba_ende IS false -- Ende melden OHNE Zeiten als Zeitnachtrag
         AND coalesce( new.ba_efftime, 0 ) + coalesce( new.ba_stk, 0 ) + coalesce( new.ba_auss, 0 ) = 0
      THEN
          new.ba_efftime := null;
      END IF;


      IF
          new.ba_o2k_id = 0
      THEN
          new.ba_o2k_id := null;
      END IF;

      new.ba_anf_rund := new.ba_anf;
      new.ba_end_rund := new.ba_end;

      IF
              new.ba_end IS null
          AND new.ba_efftime IS NOT null
      THEN
          -- Absoluter Zeiteintrag auf ABK
          -- Ende-Zeit wurde entfernt, dann auch die brechnete efftime entfernen (AG ist wieder laufend)
          IF
              tg_op = 'UPDATE'
          THEN
              IF
                  old.ba_end IS NOT null
              THEN
                  new.ba_efftime := null;
              END IF;
          END IF;

          RETURN new;
      END IF;

      IF new.ba_efftime IS null THEN
          IF
              NOT EXISTS ( SELECT true FROM ksv WHERE ks_abt=new.ba_ks AND NOT ks_notstemp )
          THEN
              RAISE EXCEPTION 'xtt1228 kst not found or not allowed: "%", ABK: %', new.ba_ks, new.ba_ix;
          END IF;
      END IF;

      IF
              TG_OP = 'INSERT'
          AND TSystem.Settings__GetBool( 'bde_nstemp_ende' )
      THEN
          IF
              EXISTS( SELECT a2_ende FROM ab2 WHERE a2_ab_ix = new.ba_ix AND a2_n = new.ba_op AND a2_ende )
          THEN
              IF
                      new.ba_ruest
                  AND new.ba_o2k_id = 10
              THEN
                  -- Abrüsten
                  new.ba_ende := true;
              ELSE
                  -- Arbeitsgang bereits beendet.
                  -- #19977 Pausen können immer beendet werden, in diesem Fall genügt eine Warnung
                  --        und die Stempelung des AG wird verworfen.
                  _pause := EXISTS( SELECT 1 FROM bdea WHERE ba_minr = new.ba_minr AND NOT ba_ende AND ba_aus_id IN ( 103, 110 ));
                  IF _pause THEN
                    PERFORM PRODAT_HINT( 'Arbeitsgang bereits beendet (ABK,AG): xtt17981 (' || new.ba_ix || ',' || new.ba_op || ')' );
                    RETURN null;
                  ELSE
                    RAISE EXCEPTION 'Arbeitsgang bereits beendet (ABK,AG): xtt17981 (%,%)', new.ba_ix, new.ba_op;
                  END IF;
              END IF;
          END IF;
      END IF;

      -- Zeitnachtrag > kein ba_end (Ende-Zeitpunkt)
      IF new.ba_end IS NULL THEN
          RETURN new;
      END IF;

      -- Pause-Status entfernen, wenn pausierter Arbeitsgang ganz beendet wird. (z.B. über die Plantafel).
      -- vgl. #14209
      IF
              new.ba_ende
          AND new.ba_aus_id IN ( 110, 103 )
      THEN
          new.ba_aus_id := null;
      END IF;

      -- Pausen abziehen in Abhängigkeit des Tagesplanes des MAB
      _tplanname :=
               mpl_tpl_name
          FROM mitpln
          WHERE mpl_date = new.ba_anf::date
            AND mpl_minr = new.ba_minr;

      -- Falls kein Pausenabzug erfolgen soll, dann hier ba_efftime errechnen
      IF
              new.ba_anf IS NOT null
          AND new.ba_end IS NOT null
      THEN
          new.ba_efftime := timediff( new.ba_anf_rund, new.ba_end_rund );
      END IF;

      -- Pausen werden nicht von der Auftragszei abgezogen (standard) oder Tagesplan nicht vorhanden
      IF
             not TSystem.Settings__GetBool( 'bdea_pause' )
          OR _tplanname IS null
      THEN
          RETURN new;
      END If;

      -- voll eingestempelt
      _f :=
            CASE
              WHEN sum( tplp_min ) IS null THEN
                  sum( timediff( tplp_begin, tplp_end ) )::numeric
              ELSE
                  sum( tplp_min / 60 )
              END
          FROM tplanpause
          WHERE tplp_tpl_name = _tplanname
            AND new.ba_anf_rund::time <= tplp_begin
            AND new.ba_end_rund::time >= tplp_end;

      new.ba_pausenab := coalesce( _f, 0 );

      -- wir haben eine Mindestangabe der Pause, deshalb ist nicht automatisch die ganze Pause Pfilcht; siehe weiter unten

      _f :=
               timediff( tplp_begin, tplp_end ) - coalesce( tplp_min / 60, 0) -- soviel darf von der Pause gearbeitet werden
          FROM tplanpause
          WHERE tplp_tpl_name = _tplanname
            AND new.ba_anf_rund::time <= tplp_begin
            AND new.ba_end_rund::time >= tplp_begin
            -- voll eingestempelt haben wir ja schon oben
            AND NOT (
                    tplp_begin >= new.ba_anf_rund::time
                AND tplp_end <= new.ba_end_rund::time
                )
          ;

      -- Gesamtzeiten die in Pausen gestempelt wurden
      -- wir ziehen von der Gesamtmindestzeit der Pause die in die Pause gestempelte Zeit ab

      _f2 := coalesce( _f, 0 );

      IF
          _f2 < 0
      THEN
          new.ba_pausenab := new.ba_pausenab - _f2;
      END IF;

      -- Efftime nachrechnen mit Pausenabzug. Betrifft nur die Einträge ohne Mehrmaschinenbedienung
      IF
              new.ba_anf IS NOT null
          AND new.ba_end IS NOT null
      THEN
          new.ba_efftime := timediff( new.ba_anf_rund, new.ba_end_rund ) - coalesce( new.ba_pausenab, 0);
      END IF;

      RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdea__b_iu
    BEFORE INSERT OR UPDATE
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea__b_iu();
--

-- #15017 Austausch Setting BDE_BDEA_STKZ_OVER_EFFTIME durch eigenes Feld ba_efftime_calc_by_stk
CREATE OR REPLACE FUNCTION bdea__b_iu__efftime_by_stk() RETURNS trigger AS $$
  BEGIN

      -- Rüsten hat nie Stückzeit * Stückzahl
      IF new.ba_ruest THEN

          new.ba_efftime_calc_by_stk := false;
          RETURN new;
      END IF;

      -- bei Pausenstempelung (keine direkte Eintragung) vorgabe übernehmen aus Kostenstelle 103/110 : Raucherpause, Pause
      IF tg_op = 'INSERT' AND new.ba_efftime_calc_by_stk IS null THEN
          new.ba_efftime_calc_by_stk := bdea__ba_efftime_calc_by_stk__calculate(new.ba_ix, new.ba_op, new.ba_minr, new.ba_ks);
      END IF;

      -- Überlegung: Wenn Stückzeit und Stückzahl, ist dies für die Auftragszeit führend.
        -- Hintergrund: Mehrmaschinenbedienung, wo einfach an- und abgestempelt wird, die Maschine aber viel steht.
        -- Beachte: efftime = 0, wenn Flag "auf Stückzeit basierend" aktiv ist und keine Stückzahl oder keine Stückzeit.
        -- Ggf. Widerspruch zu bdea__b_iu, wo ba_efftime auf null gesetzt wird.
      IF new.ba_efftime_calc_by_stk AND new.ba_end IS NOT null THEN
          new.ba_efftime := coalesce( new.ba_stk_time * new.ba_stk, 0 );
      END IF;

      RETURN new;
  END $$ LANGUAGE plpgsql;



  CREATE TRIGGER bdea__b_iu__efftime_by_stk
    BEFORE INSERT OR UPDATE
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea__b_iu__efftime_by_stk();
--

CREATE OR REPLACE FUNCTION bdea__ba_efftime_calc_by_stk__calculate(IN _ix integer, IN _op integer, IN _minr integer, IN _ks varchar) RETURNS boolean
    AS $$
        SELECT coalesce(
                   (SELECT    coalesce(ba_efftime_calc_by_stk, false)
                           OR ks_bdea_efftime_calc_by_stk -- muss eigentlich immer einen Treffer aus der KSV ergeben, sonst stimmt was nicht (fängt das äußere coalesce dann als false ab)
                      FROM ksv
                      LEFT JOIN bdea ON ba_id = (SELECT ba_id FROM bdea WHERE ba_ix = _ix AND ba_op = _op AND NOT ba_ruest AND ba_minr = _minr ORDER BY ba_id DESC LIMIT 1)
                     WHERE ks_abt = _ks
                    )
                   , false
               )
    $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION bdea__ba_efftime__sum__by__params__get(
    IN _baix    integer,
    IN _baop    integer,
    IN _ruestonly boolean = false,
    IN _ba_ks   varchar = null
    )
    RETURNS numeric
    AS $$
       SELECT coalesce((SELECT sum(ba_efftime) FROM bdea
                         WHERE ba_ix = _baix
                           AND ba_op = _baop
                               -- wenn "Nur Rüstzeit" dann eben ba_ruest, sonst alles
                           AND (   (_ruestonly AND ba_ruest)
                                OR NOT _ruestonly
                                )
                               -- alle Kostenstellen (Eingangsparameter null) oder spezifisch gefilterte (Split AG Plantafel)
                           AND (   (Equals(ba_ks, _ba_ks))
                                OR _ba_ks IS null
                                )
                        )
                        ,0
                       )
    $$ LANGUAGE sql STABLE;

--
CREATE OR REPLACE FUNCTION bdea__a_10_iu() RETURNS TRIGGER AS $$
  DECLARE _rauftg record;
          _lag record;
          _menge numeric = 0;
  BEGIN
    IF current_user = 'syncro' THEN
        RETURN new;
    END IF;

    -- Arbeitsgang der Stempelung umgeschrieben. Alten Datensatz aktualisieren
       IF (TG_OP = 'UPDATE') THEN
           IF    (old.ba_ix <> new.ba_ix)
              OR (old.ba_op <> new.ba_op)
           THEN
               -- Zeit auf alten Arbeitsgang zusammentragen
               UPDATE ab2
                      -- Gesamtzeit
                  SET a2_time_stemp        = bdea__ba_efftime__sum__by__params__get(old.ba_ix, old.ba_op),
                      -- Rüstzeit
                      a2_time_stemp__ruest = bdea__ba_efftime__sum__by__params__get(old.ba_ix, old.ba_op, true)
                WHERE a2_ab_ix = old.ba_ix
                  AND a2_n = old.ba_op;
           END IF;
       END IF;

    -- Gestempelte Zeit an AB2.
       UPDATE ab2
              -- Gesamtzeit
          SET a2_time_stemp        = bdea__ba_efftime__sum__by__params__get(new.ba_ix, new.ba_op),
              -- Rüstzeit
              a2_time_stemp__ruest = bdea__ba_efftime__sum__by__params__get(new.ba_ix, new.ba_op, true)
        WHERE a2_ab_ix = new.ba_ix
          AND a2_n = new.ba_op
       ;

    -- Maschinenausfälle sind kostenstellen-, nicht mitarbeiterspezifisch, daher alle laufenden Maschinenausfälle auf dieser Kostenstelle abstempeln, offensichtlich arbeitet die KS ja wieder
       IF tg_op='INSERT' THEN
           IF TSystem.Settings__GetBool('Bde_MaschAusf_KS') THEN
               UPDATE maschausf SET ma_end = currenttime() WHERE ma_efftime IS NULL AND ma_ks = new.ba_ks AND ma_ksap IS not DISTINCT FROM new.ba_ksap;
           END IF;
       END IF;

    -- Lager UE: automatisches Ausbuchen NUR INSERT
    IF tg_op = 'INSERT' THEN
       BEGIN
           FOR _rauftg IN SELECT *
                            FROM auftg JOIN auftgmatinfo ON agmi_ag_id = ag_id
                           WHERE ag_a2_id IN (SELECT a2_id FROM ab2 WHERE a2_ab_ix = new.ba_ix AND a2_n <= new.ba_op)
                             AND NOT ag_done
                             AND TSystem.ENUM_GetValue(ag_stat, 'UE')
           LOOP

               FOR _lag IN SELECT * FROM lag
                            WHERE lg_chnr = _rauftg.agmi_lg_chnr
                              AND lg_aknr = _rauftg.ag_aknr
                              AND lg_anztot > 0
                            ORDER BY lg_lagzudat
               LOOP
                   INSERT INTO lifsch
                               (l_ag_id,
                                l_abgg,
                                l_lgort, l_lgchnr)
                        SELECT _rauftg.ag_id,
                               least(_rauftg.ag_stk_uf1 - _rauftg.ag_stkl, _lag.lg_anztot),
                               _lag.lg_ort, _lag.lg_chnr
                     RETURNING l_abgg + _menge INTO _menge;
               END LOOP;

               -- Ausgebuchte Positionen schliessen, wenn erfüllt
               UPDATE auftg
                  SET ag_done = true
                WHERE     ag_id = _rauftg.ag_id
                  AND     ag_stkl >= ag_stk_uf1
                  AND NOT ag_done;

           END LOOP;
       EXCEPTION
           WHEN OTHERS THEN
                PERFORM prodat_error('bdea__a_10_iu - error ausbuchen ue lager:' ||  E'\n' || sqlerrm);
       END;
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdea__a_10_iu
    AFTER INSERT OR UPDATE
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea__a_10_iu();


CREATE OR REPLACE FUNCTION bdea__a_80_iu__ba_ende() RETURNS TRIGGER AS $$
    DECLARE _soll_menge numeric;
            _sum_ba_stk numeric;
    BEGIN
        -- Alles außer Abrüsten öffnet / schließt die Stempelungen oder den AG immer. Abrüsten schließt nur.
        IF (   (new.ba_o2k_id IS DISTINCT FROM 10)
            OR (new.ba_o2k_id = 10 AND new.ba_ende)
           )
           -- Im INSERT-Fall und bei direktem Nachtrag (efftime hat Wert) dann den Ende-Status in ab2 nicht anfassen: Fall z.B.: Nachtrag auf bereits beendeten AG
           AND NOT (tg_op = 'INSERT' AND new.ba_efftime IS not null AND new.ba_ende IS false)
           AND NOT  new.ba_ruest -- Beenden Rüstzeit lässt AG dennoch weiterlaufen! Dies bedeutet Rüsten beendet!
        THEN
           UPDATE ab2
              SET a2_ende = new.ba_ende
            WHERE a2_ab_ix = new.ba_ix
              AND a2_n = new.ba_op
              AND a2_ende IS DISTINCT FROM new.ba_ende
                  -- Split AG nicht beenden, da Split sonst mit verschwindet!
              AND NOT EXISTS(SELECT true FROM ab2_wkstplan
                              WHERE a2w_a2_id = a2_id
                                AND a2w_marked = -1
                             )
           ;
        END IF;

        -- Normalfall: Unterschreiten Sollmenge verhindert Abstempeln
        IF new.ba_ende
           AND NOT new.ba_ruest
           -- Setting deaktiviert dieses verhalten
           AND NOT TSystem.Settings__GetBool('BDE__bdea__stemp__ende__SollMenge__allowed')
        THEN
           _soll_menge := ab_st_uf1_soll FROM abk WHERE ab_ix = new.ba_ix;
           IF _soll_menge > 0 THEN
              _sum_ba_stk := sum(ba_stk) FROM bdea WHERE ba_ix = new.ba_ix AND ba_op = new.ba_op;
              -- ggf Unterscheidung noch Berechtigungsgruppe aktueller Nutzer. Jetzt kann nur in der ab2 beendet werden (ABK bearbeiten)
              IF _soll_menge > coalesce(_sum_ba_stk, 0) THEN
                 RAISE EXCEPTION 'ab_st_uf1_soll:% < sum(ba_stk):% xtt29754', _soll_menge, _sum_ba_stk;
              END IF;
           END IF;
        END IF;

        RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER bdea__a_80_iu__ba_ende
      AFTER INSERT OR UPDATE
      OF ba_ende
      ON bdea
      FOR EACH ROW
      EXECUTE PROCEDURE bdea__a_80_iu__ba_ende();


-- Eintrag von Ausschuss in ABK-Eigenschaften. Achte auf Auschluss von KS: TSystem.Settings__Get('Keine.Ausschuss-Steuerung.fuer.KS')
CREATE OR REPLACE FUNCTION bdea__a_20_iud_ausschuss() RETURNS TRIGGER AS $$
  BEGIN
    IF TG_OP = 'INSERT' THEN
        PERFORM tabk.set_abkrecno_unterproduktion(new.ba_ix);
    ELSIF TG_OP = 'UPDATE' THEN -- OF ba_ix, ba_op, ba_stk, ba_auss
        IF new.ba_ix <> old.ba_ix THEN
            PERFORM tabk.set_abkrecno_unterproduktion(old.ba_ix);
            PERFORM tabk.set_abkrecno_unterproduktion(new.ba_ix);
        ELSE
            PERFORM tabk.set_abkrecno_unterproduktion(new.ba_ix);
        END IF;
    ELSE -- DELETE
        PERFORM tabk.set_abkrecno_unterproduktion(old.ba_ix);
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdea__a_20_iud_ausschuss
    AFTER INSERT OR UPDATE OF ba_ix, ba_op, ba_stk, ba_auss OR DELETE
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea__a_20_iud_ausschuss();
--

CREATE OR REPLACE FUNCTION bdea__a_20_iu__ba_efftime_calc_by_stk() RETURNS TRIGGER AS $$
  BEGIN
    -- Stempelung, welche durch Pause unterbrochen wurde (Terminalstempelung) zieht automatisch den Status ihrer Ende-Stempelung mit.
    UPDATE bdea SET ba_efftime_calc_by_stk = new.ba_efftime_calc_by_stk WHERE ba_id = new.ba_id_interrupt_last AND ba_efftime_calc_by_stk IS DISTINCT FROM new.ba_efftime_calc_by_stk;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdea__a_20_iu__ba_efftime_calc_by_stk
    AFTER INSERT OR UPDATE OF ba_efftime_calc_by_stk
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea__a_20_iu__ba_efftime_calc_by_stk();

--
CREATE OR REPLACE FUNCTION bdea__a_d() RETURNS TRIGGER AS $$
  BEGIN
    IF current_user='syncro' THEN
        RETURN old;
    END IF;

    --gestempelte Zeit an AB2
    UPDATE ab2
           -- Gesamtzeit
       SET a2_time_stemp        = bdea__ba_efftime__sum__by__params__get(old.ba_ix, old.ba_op),
           -- Rüstzeit
           a2_time_stemp__ruest = bdea__ba_efftime__sum__by__params__get(old.ba_ix, old.ba_op, true)
     WHERE a2_ab_ix = old.ba_ix
       AND a2_n = old.ba_op;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdea__a_d
    AFTER DELETE
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea__a_d();
--

-- Eintragung der Durchlaufzeit Bestelldatum Auftrag bis 1. Stempelung der ABK
CREATE OR REPLACE FUNCTION bdea__a_iu_dlz() RETURNS TRIGGER AS $$
  DECLARE auftgid    INTEGER;
          auftgdbrid VARCHAR;
          auftgbdat  DATE;
  BEGIN
    auftgid=ld_ag_id FROM ldsdok WHERE ld_abk=(SELECT tplanterm.abk_main_abk(new.ba_ix));

    SELECT dbrid,ag_bdat INTO auftgdbrid, auftgbdat FROM auftg WHERE ag_id=auftgid;

    -- nur bei erster Stempelung zum Auftrag...wenn kein Stempel in anderer ABK zum Auftrag existiert
    -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Auftg
    IF
      NOT EXISTS (
        SELECT TRUE
        FROM bdea
        WHERE
           ba_ix IN ( ( SELECT ld_abk FROM ldsdok WHERE ld_ag_id = auftgid ) )
        OR ba_ix in (
            SELECT get_all_child_abk
            FROM ldsdok LEFT JOIN LATERAL tplanterm.get_all_child_abk(ld_abk) ON true WHERE ld_ag_id=auftgid
           )
        AND NOT ba_id=new.ba_id AND ba_anf < new.ba_anf )
    THEN
        PERFORM TRecnoParam.Set('auftg.dlz.Vorlauf'::VARCHAR, auftgdbrid, (new.ba_anf::DATE-auftgbdat)::INTEGER);
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdea__a_iu_dlz
    AFTER INSERT OR UPDATE
    OF ba_anf
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea__a_iu_dlz();
--

-- Auftragszeit je Mitarbeiter und Tag
CREATE OR REPLACE FUNCTION bdea__get_sumEfftime(IN minr INTEGER, IN datum DATE) RETURNS NUMERIC(12,4) AS $$
  BEGIN
    RETURN SUM(ba_efftime) FROM bdea WHERE ba_minr = minr AND ba_anf::DATE = datum;
  END $$ LANGUAGE plpgsql STABLE STRICT;
--

-- Maschinenausfallzeiten
CREATE TABLE maschausf (
  ma_id                SERIAL PRIMARY KEY,
  ma_anf               TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT currenttime(),
  ma_end               TIMESTAMP(0) WITHOUT TIME ZONE,
  ma_efftime           NUMERIC(12,2),
  ma_ks                VARCHAR(9) NOT NULL REFERENCES ksv,
  ma_ksap              VARCHAR(25),
  ma_minr              INTEGER REFERENCES llv,
  ma_ba_id             INTEGER REFERENCES bdea ON DELETE CASCADE,
  ma_aus_id            INTEGER NOT NULL REFERENCES bdeausgruende,
  ma_ausftext          TEXT
 );

 -- Inizes
  CREATE INDEX maschaus_ma_ks ON maschausf(ma_ks);
  CREATE INDEX maschaus_ma_ks_ma_end_not_null_plantafel ON maschausf(ma_ks) WHERE ma_end IS NOT NULL;
  CREATE INDEX maschausfend ON maschausf(ma_end, ma_minr);
  CREATE INDEX maschausf_anf ON maschausf(CAST(ma_anf AS DATE));
  CREATE INDEX maschausf_anf_pg81 ON maschausf(timestamp_to_date(ma_anf));
  CREATE INDEX maschausf_end ON maschausf(CAST(ma_end AS DATE));
  CREATE INDEX maschausf_active ON maschausf(ma_ks) WHERE ma_end IS NULL;
  CREATE INDEX maschausf_week ON maschausf(termweek(ma_anf));
  CREATE INDEX maschausf_week_end ON maschausf(termweek(ma_end));
 --
 CREATE OR REPLACE FUNCTION maschausf__b_iu() RETURNS TRIGGER AS $$
   BEGIN
      IF new.ma_end IS NOT NULL THEN
         new.ma_efftime := timediff(new.ma_anf, new.ma_end);
      END IF;

      -- Anstempeln Produktionsausfall: laufende Aufträge abstempeln je nach Option
      IF (TG_OP = 'INSERT') AND new.ma_efftime IS NULL THEN

         IF TSystem.Settings__GetBool('Bde_MaschAusf_KS') THEN -- Maschinenausfälle sind Kostenstellen - statt Mitarbeiterspezifisch, daher alle laufenden Aufträge abstempeln
            IF TSystem.Settings__GetBool('BDE_TEILERM_STANDARD_FOR_AUFTG')  -- Es ist auch Pflicht alle Aufträge mit Teilmengen zurückzumelden. Ausfall erfassen geht nicht, da ja noch andere laufen könnten.
               AND EXISTS ( SELECT true FROM bdea WHERE ba_ks=new.ma_ks AND ba_ksap IS not DISTINCT FROM new.ma_ksap AND ba_end IS NULL AND ba_efftime IS NULL)
            THEN
               RAISE EXCEPTION 'xtt12512 Es kann kein Produktionsausfall erfasst werden, solange nicht alle laufenden Aufträge zurückgemeldet sind';
            END IF;

            -- alle laufenden Aufträge auf dieser Kostenstelle abstempeln
            UPDATE bdea
               SET ba_end = now(),
                   ba_aus_id = new.ma_aus_id
             WHERE ba_ks = new.ma_ks
               AND ba_ksap IS not DISTINCT FROM new.ma_ksap
               AND ba_end IS NULL
               AND ba_efftime IS NULL;
         ELSE
            -- Prod.Ausfall: nur eigenen Auftrag abstempeln
            UPDATE bdea
               SET ba_end = now(),
                   ba_aus_id = new.ma_aus_id
             WHERE ba_ks = new.ma_ks
               AND ba_ksap IS not DISTINCT FROM new.ma_ksap
               AND ba_end IS NULL
               AND ba_efftime IS NULL
               AND new.ma_minr = ba_minr;
         END IF;
      END IF;

      RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER maschausf__b_iu
     BEFORE INSERT OR UPDATE
     ON maschausf
     FOR EACH ROW
     EXECUTE PROCEDURE maschausf__b_iu();


 -- Auftragszeit mit Ausfallgrund => in die Maschausfall
 CREATE OR REPLACE FUNCTION bdea_do_maschausf() RETURNS TRIGGER AS $$
  BEGIN
   -- Raucherpausen und Unterbrechung durch RFID-Terminal sind keine Maschinenausfälle.
   IF (old.ba_aus_id IS NULL) AND (old.ba_end IS NULL) AND (new.ba_aus_id IS NOT NULL) AND (new.ba_aus_id NOT IN (103, 110)) THEN
         INSERT INTO maschausf (ma_aus_id, ma_ks, ma_ksap, ma_ba_id, ma_minr) VALUES (new.ba_aus_id, new.ba_ks, new.ba_ksap, new.ba_id, new.ba_minr);
   END IF;

   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bdea_do_maschausf
    AFTER UPDATE
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea_do_maschausf();


 CREATE OR REPLACE FUNCTION bdea_do_maschausf_ins() RETURNS TRIGGER AS $$
  BEGIN
      IF current_user='syncro' THEN
            RETURN new;
      END IF;
      --Ausfallgrund angegeben ... Eintrag in Maschausfall
      IF (new.ba_aus_id IS NOT NULL) THEN
            IF new.ba_aus_id NOT IN (103, 110) THEN -- nicht bei Pausen/Raucherpausen (z.B. RFID-Stemp)
                    INSERT INTO maschausf (ma_aus_id, ma_ks, ma_ksap, ma_ba_id) VALUES (new.ba_aus_id, new.ba_ks, new.ba_ksap, new.ba_id);
            END IF;
      ELSE
            UPDATE maschausf SET ma_end=currenttime() WHERE ma_end IS NULL AND ma_minr=new.ba_minr AND ma_efftime IS NULL;
      END IF;
      RETURN new;
  END $$ LANGUAGE plpgsql;


  CREATE TRIGGER bdea_do_maschausf_ins
    AFTER INSERT
    ON bdea
    FOR EACH ROW
    EXECUTE PROCEDURE bdea_do_maschausf_ins();



 CREATE OR REPLACE FUNCTION maschausf_in_week_plantafel(ks VARCHAR, week INTEGER) RETURNS BOOL AS $$
     DECLARE result BOOLEAN;
     BEGIN
        --RETURN false;
        RESULT:=
        EXISTS(SELECT true FROM maschausf WHERE ma_ks=ks AND ma_end IS NOT NULL AND
                     termweek(ma_anf)<=week
                     AND
                     termweek(ma_end)>=week--aktuelle Woche
                     AND
                     NOT ma_end<=current_date
                    --vollständig, mit an- und abstempelzeit
                    );
        IF result THEN
           RETURN result;
        END IF;
        RETURN EXISTS(SELECT true FROM maschausf WHERE ma_ks=ks AND ma_end IS NOT NULL AND
                    (
                     termweek(ma_anf)=week
                     AND
                     ma_efftime IS NOT NULL
                    )
                    );--nachtrag von maschinenausfall
     END $$ LANGUAGE plpgsql STABLE;

 /*Termin-Kalender*/

 CREATE TABLE cimkal
  (kal_id               SERIAL PRIMARY KEY,
   kal_anf              TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL,
   kal_end              TIMESTAMP(0) WITHOUT TIME ZONE,
   kal_evryyear         BOOLEAN,
   kal_bez              VARCHAR(50) NOT NULL,
   kal_stunden          TIME,
   kal_bde              BOOLEAN/*ereignis der BDE*/
   CONSTRAINT xtt5037 CHECK(kal_end IS NULL OR kal_anf<kal_end)
  );

 CREATE INDEX kal_date ON cimkal(kal_anf);

/*Feiertage*/
CREATE TABLE feiertag (
  ft_id         SERIAL PRIMARY KEY,
  ft_date       DATE NOT NULL UNIQUE,
  ft_bez        VARCHAR(50) NOT NULL,
  ft_stu        NUMERIC,
  ft_urlaub     BOOLEAN NOT NULL DEFAULT FALSE
  -- ft_evryyear   BOOLEAN NOT NULL DEFAULT FALSE
  );
--

--
CREATE OR REPLACE FUNCTION feiertag_a_d() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE mitpln SET mpl_feiertag=NULL WHERE mpl_date=old.ft_date;
    RETURN old;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER feiertag_a_d
    AFTER DELETE
    ON feiertag
    FOR EACH ROW
    EXECUTE PROCEDURE feiertag_a_d();
--

--
CREATE OR REPLACE FUNCTION feiertag__a_iu_ftdate() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE bdepab SET dbrid=dbrid WHERE new.ft_date BETWEEN bdab_anf AND bdab_end AND NOT bdab_buch; -- Änderung auslösen, damit die Urlaubsgrenzen richtig verlaufen
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER feiertag__a_iu_ftdate
    AFTER INSERT OR UPDATE OF ft_date
    ON feiertag
    FOR EACH ROW
    EXECUTE PROCEDURE feiertag__a_iu_ftdate();
--

 CREATE TABLE ferien
  (fte_id               SERIAL PRIMARY KEY,
   fte_anf              DATE NOT NULL UNIQUE,
   fte_end              DATE NOT NULL,
   fte_bez              VARCHAR(50) NOT NULL,
   CONSTRAINT xtt5037 CHECK (fte_end >= fte_anf)
  );
--


-- Tagespläne
 CREATE TABLE tplan (
   tpl_name             VARCHAR(20) NOT NULL PRIMARY KEY,
   tpl_rbegin           TIME(0) WITHOUT TIME ZONE NOT NULL,
   tpl_rend             TIME(0) WITHOUT TIME ZONE NOT NULL,
   tpl_min              NUMERIC,
   tpl_max              NUMERIC,
   tpl_abw              NUMERIC,
   tpl_vhz              NUMERIC NOT NULL DEFAULT 0,
   tpl_zeitrund         NUMERIC NOT NULL DEFAULT 1,         -- Zeiten max. in Minuten (keine Überzeiten in Sekunden oder weniger, durch erhöhte Präzision notwendig, #5105)
   tpl_uebstund         NUMERIC NOT NULL DEFAULT 1,         -- Überstunden werden gerundet in 15 Minuten Takt (ebenso mind. 1 Minute, #5105)
   tpl_uebstundab       NUMERIC,                            -- Überstunden zählen ab 30 minuten mehr
   tpl_nachtv           TIME(0) WITHOUT TIME ZONE,
   tpl_nachtb           TIME(0) WITHOUT TIME ZONE,
   tpl_nachterlaubt     BOOLEAN NOT NULL DEFAULT FALSE,
   tpl_minpause         NUMERIC,                            -- Mindestpause in h. Abzug der angg. Pause erfolgt definitiv (wenn nicht gestempelt oder durch Gesamtpause gedeckt). Also unabhängig der gesamten Präsenzzeit.
                                                            -- 0 führt zu keinem Pausenabzug (überdeckt globale Mindestpausen). NULL führt zum Pausenabzug laut globaler Mindestpausen. #11814
   tpl_ungueltdatum     DATE
   --CONSTRAINT xtt5037 CHECK(tpl_rbegin<tpl_rend)
   );
--

 CREATE OR REPLACE FUNCTION tplan__b_iu() RETURNS TRIGGER AS $$
 BEGIN
  IF new.tpl_nachtv IS NOT NULL AND new.tpl_nachtb IS NOT NULL THEN
        new.tpl_nachterlaubt:=True;
  ELSE
        new.tpl_nachterlaubt:=False;
  END IF;
  --
  RETURN new;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER tplan__b_iu
 BEFORE INSERT OR UPDATE
 ON tplan
 FOR EACH ROW
 EXECUTE PROCEDURE tplan__b_iu();


 CREATE TABLE minpause
  (mp_id                SERIAL PRIMARY KEY,
   mp_arbstu            NUMERIC,
   mp_minpause          NUMERIC
  );


 /*CREATE TABLE llvgroups
  (llg_id               SERIAL PRIMARY KEY,
   llg_groupname        VARCHAR(30) NOT NULL UNIQUE,
   llg_mo               VARCHAR(30) REFERENCES tplan,
   llg_di               VARCHAR(30) REFERENCES tplan,
   llg_mi               VARCHAR(30) REFERENCES tplan,
   llg_do               VARCHAR(30) REFERENCES tplan,
   llg_fr               VARCHAR(30) REFERENCES tplan,
   llg_we               VARCHAR(30) REFERENCES tplan
  );*/

  /*Tagespläne zeitspezifisch für Mitarbeoiter*/

 CREATE TABLE llv_autoplan
  (llpl_id              SERIAL NOT NULL PRIMARY KEY,
   llpl_minr            INTEGER NOT NULL REFERENCES llv ON UPDATE CASCADE ON DELETE CASCADE,
   llpl_anf             TIME(0) NOT NULL,
   llpl_end             TIME(0) NOT NULL,
   llpl_tpl_name        VARCHAR(20) REFERENCES tplan ON UPDATE CASCADE,
   llpl_tpl_name_fr     VARCHAR(20) REFERENCES tplan ON UPDATE CASCADE,
   llpl_tpl_name_sa     VARCHAR(20) REFERENCES tplan ON UPDATE CASCADE,
   llpl_tpl_name_so     VARCHAR(20) REFERENCES tplan ON UPDATE CASCADE,
   CONSTRAINT xtt5037 CHECK(llpl_anf<llpl_end)
  );

  CREATE OR REPLACE FUNCTION llv_autoplan__b_iu() RETURNS TRIGGER AS $$
  BEGIN
   IF (SELECT true FROM llv_autoplan WHERE (llpl_id<>new.llpl_id) AND llpl_minr=new.llpl_minr AND (llpl_anf BETWEEN new.llpl_anf AND new.llpl_end OR llpl_end BETWEEN new.llpl_anf AND new.llpl_end OR (llpl_anf<new.llpl_anf AND llpl_end>new.llpl_end)) LIMIT 1)=TRUE THEN
        RAISE EXCEPTION 'xtt5042 another autoplan has this time already';
   END IF;
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER llv_autoplan__b_iu
  BEFORE INSERT OR UPDATE
  ON llv_autoplan
  FOR EACH ROW
  EXECUTE PROCEDURE llv_autoplan__b_iu();


 /*ein Tagesplan kann einem Ausfallgrund zugeordnet werden*/

 /*ALTER TABLE bdeausgruende ADD COLUMN aus_tplan VARCHAR(20) REFERENCES tplan ON UPDATE CASCADE ON DELETE RESTRICT;*/

 /*Check beim Ändern von Gleitzeit dass auch keine Blockzeitverletzung*/

 CREATE OR REPLACE FUNCTION check_tplan() RETURNS TRIGGER AS $$
 BEGIN
  /*werden beim ändern auch kein Blockzeiten bzw Pausen verletzt?*/
  IF (SELECT count(*) FROM tplanblock WHERE new.tpl_name=tplbl_tpl_name AND (new.tpl_rbegin>tplbl_begin OR new.tpl_rend<tplbl_end))>0
     THEN RAISE EXCEPTION  'xtt5056 tplanblock out of tplan Range Err';
  END IF;
  /*jetzt prüfen das beim Ändern keine Pausen verletzt werden*/
  IF (SELECT count(*) FROM tplanpause WHERE tplp_tpl_name=new.tpl_name AND (new.tpl_rbegin>tplp_begin OR new.tpl_rend<tplp_end))>0
       THEN RAISE EXCEPTION  'xtt5058 tplanpause out of tplan Range Err';
  END IF;
  RETURN NEW;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER check_tplan
 BEFORE UPDATE
 ON tplan
 FOR EACH ROW
 EXECUTE PROCEDURE check_tplan();


-- Blockzeiten im Plan
CREATE TABLE tplanblock (
  tplbl_id             SERIAL PRIMARY KEY,
  tplbl_tpl_name       VARCHAR(20) NOT NULL REFERENCES tplan ON UPDATE CASCADE ON DELETE CASCADE,
  tplbl_begin          TIME(0) WITHOUT TIME ZONE NOT NULL,
  tplbl_end            TIME(0) WITHOUT TIME ZONE NOT NULL,
  tplbl_pause          SMALLINT
);

CREATE INDEX tplbl_tpl_name ON tplanblock (tplbl_tpl_name);

-- Check beim Einfügen der Blockzeiten, dass auch innerhalb Gleitzeit
CREATE OR REPLACE FUNCTION check_tplanblock() RETURNS TRIGGER AS $$
   BEGIN
    IF current_user = 'syncro' THEN
        RETURN new;
    END IF;

    -- Überschneidung von Blockzeitzeiten des Tagesplans prüfen
    IF EXISTS(
        SELECT true
        FROM tplanblock
        WHERE tplbl_tpl_name = new.tplbl_tpl_name
          AND tplbl_id <> new.tplbl_id
          AND (
               ( tplbl_begin <= new.tplbl_begin AND tplbl_end >= new.tplbl_begin )
            OR ( tplbl_begin <  new.tplbl_end   AND tplbl_end >  new.tplbl_end )
            OR ( tplbl_begin >= new.tplbl_begin AND tplbl_end <= new.tplbl_end )
          )
        )
    THEN
        RAISE EXCEPTION 'xtt5042 tplanblock Range Error';
    END IF;

    -- Blockzeiten für Nachtschichten (als Tagesplan) nicht implementiert
    IF EXISTS(
        SELECT true
        FROM tplan
        WHERE tpl_name = new.tplbl_tpl_name
          AND tpl_rbegin > tpl_rend
        )
    THEN
        RAISE EXCEPTION '%', lang_text(16784);
    END IF;

    -- Prüfung, ob innerhalb der Tagesplan-Zeit. Auch hiermit Einträge von Blockzeiten bei Nachtschichten nicht möglich (1:00 bis 2:00).
    IF EXISTS(
        SELECT true
        FROM tplan
        WHERE tpl_name = new.tplbl_tpl_name
          AND (
               tpl_rbegin > new.tplbl_begin
            OR tpl_rend   < new.tplbl_end
          )
        )
    THEN
        RAISE EXCEPTION 'xtt5042 tplanblock out of tplan Range Err';
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER check_tplanblock
    BEFORE INSERT OR UPDATE
    ON tplanblock
    FOR EACH ROW
    EXECUTE PROCEDURE check_tplanblock();
--

-- Pausen in Blockzeiten
CREATE TABLE tplanpause (
  tplp_id              SERIAL PRIMARY KEY,
  tplp_tpl_name        VARCHAR(20) NOT NULL REFERENCES tplan ON UPDATE CASCADE ON DELETE CASCADE,
  tplp_begin           TIME(0) WITHOUT TIME ZONE NOT NULL,
  tplp_end             TIME(0) WITHOUT TIME ZONE NOT NULL,
  tplp_min             NUMERIC
);

CREATE INDEX tplp_tpl_name ON tplanpause(tplp_tpl_name);

-- Check beim einfügen der Pausen ob auch im Block gelegen
CREATE OR REPLACE FUNCTION check_tplanpause() RETURNS TRIGGER AS $$
  BEGIN
    IF current_user = 'syncro' THEN
        RETURN new;
    END IF;

    -- Pause über Mitternacht nicht implementiert
    IF new.tplp_begin > new.tplp_end THEN
        RAISE EXCEPTION '%', lang_text(16785);
    END IF;

    -- Prüfung, ob für gleichen Tagesplan überlappende Einträge gibt
    IF EXISTS(
        SELECT true FROM tplanpause
        WHERE tplp_tpl_name = new.tplp_tpl_name
          AND tplp_id <> new.tplp_id
          -- Prüfung über Tagesgrenze nicht trivial: Range bereits vorhandener Datensätze in Abhänigkeit des neuen Eintrags aufspannen.
          AND    tsystem.times_to_tsrange(new.tplp_begin, new.tplp_end, NULL, false)
              && tsystem.times_to_tsrange(tplp_begin, tplp_end, NULL, new.tplp_begin >= tplp_begin AND new.tplp_end >= tplp_end)
      )
    THEN
        RAISE EXCEPTION 'xtt5042 tplanpause Range Error';
    END IF;

    -- Ist Eintrag innerhalb der Tagesplan-Zeit?
    IF NOT EXISTS(
        SELECT true FROM tplan
        WHERE tpl_name = new.tplp_tpl_name
          -- Prüfung über Tagesgrenze nicht trivial: Range des Tagesplans in Abhänigkeit des neuen Eintrags aufspannen.
          AND    tsystem.times_to_tsrange(new.tplp_begin, new.tplp_end, NULL, false)
              <@ tsystem.times_to_tsrange(tpl_rbegin, tpl_rend, NULL, new.tplp_begin >= tpl_rbegin AND new.tplp_end >= tpl_rend)
      )
    THEN
        RAISE EXCEPTION 'xtt5058 tplanpause out of tplan Range Err';
    END IF;

    IF timediff(new.tplp_begin, new.tplp_end) * 60 = new.tplp_min THEN
        new.tplp_min := NULL;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER check_tplanpause
    BEFORE INSERT OR UPDATE
    ON tplanpause
    FOR EACH ROW
    EXECUTE PROCEDURE check_tplanpause();
--

-- für jeden Tag einen bestimmten Tagesplan eintragen
CREATE TABLE mitpln (
  mpl_id               serial PRIMARY KEY,
  mpl_formonth         integer,
  mpl_date             date,
  mpl_minr             integer NOT NULL REFERENCES llv ON UPDATE CASCADE ON DELETE CASCADE,
  mpl_tpl_name         varchar(20) CONSTRAINT xtt1457__mpl_tpl_name REFERENCES tplan ON UPDATE CASCADE,
  mpl_feiertag         varchar(50),
  mpl_min              numeric(12,4),
  mpl_max              numeric(12,4),
  mpl_saldo            numeric(12,4), -- Tagessaldo Präsenzzeit
  mpl_buch             boolean NOT NULL DEFAULT false,
  mpl_absaldo          numeric(12,4),
  mpl_vhz              numeric(12,4),
  mpl_freigabe         boolean NOT NULL DEFAULT false
);

-- Indizes
  CREATE INDEX mpl_minr ON mitpln(mpl_minr);
  CREATE UNIQUE INDEX xtt5126 ON mitpln(mpl_date, mpl_minr);
  CREATE INDEX mpl_minr_nobuch ON mitpln(mpl_minr) WHERE NOT mpl_buch;
  CREATE INDEX mitpln_yearmonth_dec ON mitpln(date_to_yearmonth_dec(mpl_date));
  CREATE INDEX mitpln_formonth ON mitpln(mpl_formonth);
  CREATE INDEX mitpln_tpl_name ON mitpln(mpl_tpl_name, mpl_date);
--

--
CREATE OR REPLACE FUNCTION mitpln__b_iu() RETURNS TRIGGER AS $$
  DECLARE
      f numeric;
      tplanname varchar;
      mplmin numeric;
      mplvhz numeric;
      urlaub boolean;
      anfz timestamp(0);
      bdab_sum numeric;

      -- ab_id 1: Urlaub
      -- ab_id 100: 1/2 Urlaub
      _urlaub_ids CONSTANT int[] := array[ 1, 100 ];

  BEGIN -- wir holen uns die Mindestzeit aus dem Tagesplan
      IF TG_OP = 'INSERT' THEN
          IF EXISTS(SELECT true FROM mitpln WHERE mpl_minr = new.mpl_minr AND mpl_date = new.mpl_date) THEN
              RETURN NULL;
          END IF;
      END IF;

      IF TG_OP = 'UPDATE' THEN
          IF NOT new.mpl_buch AND old.mpl_buch THEN -- Verbuchen rückgängig machen
              -- Abwesenheiten
              UPDATE bdepab SET bdab_buch = false WHERE bdab_buch AND new.mpl_date BETWEEN bdab_anf AND bdab_end AND bdab_minr = new.mpl_minr;
              -- Stempelungen
              UPDATE bdep SET bd_buch = false WHERE bd_buch AND bd_minr = new.mpl_minr AND bd_individwt_mpl_date = new.mpl_date;
              -- Auszahlungen
              UPDATE stundauszahl SET sa_buch = false WHERE sa_buch AND sa_minr = new.mpl_minr AND sa_date = new.mpl_date;
          END IF;
      END IF;

      new.mpl_formonth := date_to_yearmonth_dec(new.mpl_date - TSystem.Settings__GetInteger('anfdaymonth'));

      IF (current_user = 'syncro' OR new.mpl_buch) THEN
          IF NOT old.mpl_buch AND new.mpl_buch AND new.mpl_formonth >= date_to_yearmonth_dec(current_date) THEN -- Dieser Monat ist noch gar nicht vorbei und kann somit auch nicht verbucht werden.
              RAISE EXCEPTION 'xtt6119 month not done %', new.mpl_date;
          END IF;

          RETURN new;
      END IF;

      IF (TG_OP = 'INSERT' OR current_user = 'root' OR new.mpl_absaldo IS NULL) THEN -- sonst bekommt man Betriebsurlaub nicht mehr raus! Dieser Automatismuss darf nur bei Insert !!!
          -- dürfen wir hier überhaupt noch was einfügen oder ist das bereits verbucht?
          IF date_to_yearmonth_dec(new.mpl_date) < (SELECT max(llsh_monthyear) FROM llv_stuko_history WHERE llsh_ll_minr = new.mpl_minr) THEN
              RAISE EXCEPTION 'xtt6118 month already done : minr : % - date : %', new.mpl_minr, new.mpl_date;
          END IF;

          SELECT ft_bez, ft_urlaub INTO new.mpl_feiertag, Urlaub FROM feiertag WHERE ft_date = new.mpl_date; -- Feiertag eintragen falls da
          IF urlaub THEN -- dies ist ein normaler Urlaubstag und kein Feiertag. Es ist halt Betriebsurlaub.
              new.mpl_feiertag := NULL;
          END IF;
      END IF;

      IF TG_OP <> 'INSERT' THEN
          IF new.mpl_tpl_name <> old.mpl_tpl_name THEN
              new.mpl_min := NULL; -- Änderung Tagesplan = neu ermitteln der Minimumzeit
              new.mpl_absaldo := NULL; -- Änderung Tagesplan = evtl Änderung der Gutschrift für den Tag
          END IF;
      END IF;

      -- wenn das Urlaub aus dem Betriebskalender ist, dann nicht als Feiertag sondern als Urlaub annehmen
      Urlaub := COALESCE(Urlaub, false);

      mplvhz := 0;

      IF new.mpl_tpl_name IS NULL THEN -- wenn noch kein Tagesplan da, dann einen eintragen!
          anfz := NULL;
          anfz := MIN(bd_anf) FROM bdep WHERE bd_minr = new.mpl_minr AND bd_individwt_mpl_date = new.mpl_date;
          new.mpl_tpl_name := tpersonal.bde__llv_standplan__get(new.mpl_date, anfz::TIME(0), new.mpl_minr);
      END IF;

      IF new.mpl_feiertag IS NULL THEN
          mplvhz := tpl_vhz / 60 FROM tplan WHERE tpl_name = new.mpl_tpl_name;
      END IF;

      SELECT tpl_min, tpl_max
        INTO mplmin, new.mpl_max
        FROM tplan
       WHERE tpl_name = new.mpl_tpl_name;

      new.mpl_min := mplmin + mplvhz;
      new.mpl_vhz := mplvhz;

      new.mpl_min := coalesce(new.mpl_min, 0);

      -- wir rechnen die Gesamtzeiten der Abwesenheiten zusammen
      f := SUM(bdab_stu) FROM bdepab
                        WHERE bdab_minr = new.mpl_minr
                          AND new.mpl_date BETWEEN bdab_anf AND bdab_end
                          AND bdab_stu IS NOT NULL; -- Abwesenheitsgutschrift steht in Abwesendgrund
      -- wir haben jetzt die eingetragenen Abwesenheiten für diesen Tag wo es separate Gutschriften gibt.
      new.mpl_absaldo := coalesce(f, 0); --wir setzen 0
      -- jetzt holen wir noch die Abwesenheitstunden aus dem Feiertag!!!
      IF new.mpl_feiertag IS NOT NULL THEN -- Feiertag
          SELECT ft_stu, ft_urlaub INTO f, urlaub FROM feiertag WHERE ft_date = new.mpl_date;

          IF f IS NULL THEN
              f := tpl_abw FROM tplan WHERE tpl_name = new.mpl_tpl_name;
          END IF;

          new.mpl_absaldo := new.mpl_absaldo + COALESCE(f, 0);

          IF NOT TSystem.Settings__GetBool('BDE_FEIERT_MIT_VORG') AND NOT Urlaub THEN -- Feiertag werden nicht mit Vorgaben gefüllt
              new.mpl_min := 0;
              new.mpl_absaldo := SUM(bdab_stu) FROM bdepab WHERE bdab_minr = new.mpl_minr AND new.mpl_date BETWEEN bdab_anf AND bdab_end AND bdab_stu IS NOT NULL; -- Abwesenheitsgutschrift steht in Abwesendgrund
          END IF; -- Feiertage werden mit Vorgaben gefüllt.!

          new.mpl_vhz := 0;
      ELSE -- jetzt, falls dies kein Feiertag war - die Abwesenheiten die keine Zeit eingetragen haben, also die Vorgabe aus dem Tagesplan bekommen
          -- Zeit kommt aus Tagesplan, in bdepab ist keine Gutschriftzeit eingetragen
          IF EXISTS(SELECT true FROM bdepab -- AND bdab_stu IS NULL
                     WHERE bdab_minr = new.mpl_minr
                       AND new.mpl_date BETWEEN bdab_anf AND bdab_end
                       AND bdab_stu IS NULL
                    )
          THEN -- es gibt Abwesenheiten für diesen Tag die automatisch die Tagesplangutschrift bekommen
              -- Summe der Abwesenheiten in Abhängigkeit vom Tagesplan
              f := SUM(COALESCE(ab_stu,1) * tpl_abw)
                        FROM bdeabgruende
                        JOIN bdepab ON ab_id = bdab_aus_id
                        JOIN tplan ON tpl_name = new.mpl_tpl_name
                        WHERE bdab_minr = new.mpl_minr
                          AND new.mpl_date BETWEEN bdab_anf AND bdab_end
                          AND bdab_stu IS NULL; -- Abwesenheitsgutschrift steht in Abwesendgrund

              new.mpl_absaldo := new.mpl_absaldo + COALESCE(f, 0); -- die Gutschrift wird zum Tag dazugerechnet
          END IF;

          IF EXISTS( -- FROM bdepab WHERE bdab_aus_id = any( _urlaub_ids )
               SELECT true
                 FROM bdepab
                 JOIN bdeabgruende ON bdab_aus_id = ab_id
                WHERE new.mpl_date BETWEEN bdab_anf AND bdab_end
                  AND bdab_minr = new.mpl_minr
                  AND (
                          -- klärungsbedarf: https://redmine.prodat-sql.de/issues/15015
                          bdab_aus_id = any( _urlaub_ids )
                       OR NOT coalesce( ab_vhz, true )
                      )
             )
          THEN
              new.mpl_min := new.mpl_min - new.mpl_vhz; -- an Urlaubstagen zählt die Vorholzeit nicht mit oder wenn das so angegeben ist (Vorholzeit im Abwesenheitsgrund ist aus)!!!
              new.mpl_vhz := 0;
          END IF;
      END IF;


      new.mpl_min     := coalesce( new.mpl_min, 0 );
      new.mpl_absaldo := coalesce( new.mpl_absaldo, 0 );

      -- Kein Saldo (keine Stempelung, nur Abwesenheit an dem Tag)
      new.mpl_saldo := coalesce( new.mpl_saldo, 0 );

      -- Berücksichtigung der maximalen Arbeitszeit gemäß Tagesplan:
        -- Wenn ein Tages-Max. angegeben ist, ist der Saldo auch maximal dieser Tagessaldo, somit der kleinere Wert aus
        -- Max-Tagessaldo und gestempelter Zeit

        -- Saldo wird noch mit den Abwesenheiten verrechnet, um das Maximum der tatsächlichen Arbeitszeit zu ermitteln.
        -- Hintergrund:
          -- Abwesenheit (mpl_absaldo) ist negativ bei Abzug (z.B. Mindestpause), positiv bei Gutschrift (z.B. Urlaub).
          -- z.B. bei Kurzarbeit haben wir eine Gutschrift durch Abwesenheit.
          -- Die Stempelungen dürfen dann den Rest nicht überschreiten.
          -- Bsp: Max = 9; Saldo = 10; MinPause = -0,5 => Saldo wird = 9,5 (9 - -0,5), also 9,5 - 0,5 (Pause) = 9 (Max).
      new.mpl_saldo := least( new.mpl_saldo, new.mpl_max - new.mpl_absaldo );


      RETURN new;

  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER mitpln__b_iu
    BEFORE INSERT OR UPDATE
    ON mitpln
    FOR EACH ROW
    EXECUTE PROCEDURE mitpln__b_iu();
--

  --#8145 Freigabestatus zurücksetzen, wenn Änderungen an der Präsenzzeit
  CREATE OR REPLACE FUNCTION mitpln__b_u_freigabe() RETURNS TRIGGER AS $$
  BEGIN
    If (current_user='syncro')OR(new.mpl_buch) THEN -- Wenn bereits verbucht, nichts machen
        RETURN new;
    END IF;
    --
    new.mpl_freigabe:=False; --Freigabestatus zurücksetzen
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER mitpln__b_u_freigabe
   BEFORE UPDATE
   ON mitpln
   FOR EACH ROW
   WHEN (new.mpl_freigabe AND (old.mpl_saldo<>new.mpl_saldo))
   EXECUTE PROCEDURE mitpln__b_u_freigabe();


-- automatisch die Mitarbeitertagespläne in die Mitplneinfügen, um lücken zu schliessen und Fehltage zu Gleitzeikompensation werden zu lassen
CREATE OR REPLACE FUNCTION mitpln__a_iu() RETURNS TRIGGER AS $$
      DECLARE
            _anfd      date;
            _outdate   date;
            _llab      integer;
            _buchmonth integer;
      BEGIN
            IF current_user = 'syncro' OR new.mpl_buch THEN
                RETURN new;
            END IF;

            -- Betriebsurlaub eintragen, wenn nicht eingetragen wurde bereits!
            IF  EXISTS( -- dies ist Betriebsurlaub
                  SELECT true
                  FROM feiertag
                  WHERE ft_date = new.mpl_date
                    AND ft_urlaub
                    AND NOT EXISTS(
                          SELECT true
                          FROM bdep
                          WHERE bd_minr = new.mpl_minr
                            AND bd_individwt_mpl_date = new.mpl_date
                    )
                )
            THEN
                IF  -- es darf keine Abwesenheit eingetragen sein. andere Abwesenheiten deaktivieren den automatismus des Urlaub eintragens
                         NOT EXISTS(SELECT true
                                      FROM bdepab
                                     WHERE bdab_minr = new.mpl_minr
                                       AND new.mpl_date BETWEEN bdab_anf AND bdab_end
                                    -- Folgendes auskommentiert, Betriebsurlaub nur, wenn nichts anderes. https://redmine.prodat-sql.de/issues/17434
                                    -- AND bdab_aus_id IN (1, 2) -- Urlaub, Krank    tpersonal.urlaub__ids(), tpersonal.krank__ids() => beachte zB : bdeabgruende__Gutschrift_Is
                                       AND bdab_aus_id NOT IN (101, 103) -- Mindestpause, Raucherpause
                                    )
                    -- es muss einen Tagesplan geben bzw. es muss eine Sollzeit geben
                    AND coalesce((SELECT tpl_min FROM tplan WHERE tpl_name = coalesce(new.mpl_tpl_name, tpersonal.bde__llv_standplan__get(new.mpl_date, null, new.mpl_minr))), 0) > 0
                THEN
                    -- Diesen Feiertag als Urlaub eintragen.
                    INSERT INTO bdepab (bdab_anf,     bdab_end,     bdab_minr,    bdab_aus_id)
                    VALUES             (new.mpl_date, new.mpl_date, new.mpl_minr, 1);
                END IF;
            END IF;

            -- letzte Stempelung dieses Mitarbeiters holen und evtl Lücke mit Standardtagesplänen schliessen
            _anfd := max(mpl_date) FROM mitpln WHERE mpl_minr = new.mpl_minr AND mpl_id <> new.mpl_id AND mpl_date < new.mpl_date;

            --letzte Stempelung liegt mehr als 60 Tage zurück. Dann ist das eine "gewollte Lücke"
            IF _anfd < new.mpl_date - 60 THEN
                  _anfd := NULL;
            END IF;

            --das ist der Standardabwesenheitsgrund
            SELECT ll_stand_ab_id INTO _llab FROM llv WHERE ll_minr = new.mpl_minr;

            SELECT max(llsh_monthyear) INTO _buchmonth FROM llv_stuko_history WHERE llsh_ll_minr = new.mpl_minr;

            IF _anfd IS NOT NULL THEN
                -- Von der letzten Stempelung bis heute durchlaufen und fehlende Feiertage usw. eintragen.
                -- Beachte : procedure TProdatSrvXEService.BDEAutoStemp; Trägt ebenfalls fehlende Vortage ein
                FOR i IN 0 .. new.mpl_date - _anfd LOOP
                    IF    (EXTRACT(dow FROM _anfd + i) BETWEEN 1 AND 5)
                          -- ODER ein Wochenendeplan mit Sollzeit => Sonntag ist Arbeitstag (Kommod) aber es wurde nicht gearbeitet!
                       OR (SELECT tpl_min FROM tplan WHERE tpl_name = tpersonal.bde__llv_standplan__get(_anfd + i, null, new.mpl_minr)) > 0
                    THEN
                        IF      _anfd + i <= current_date
                            AND NOT EXISTS(
                                  SELECT true
                                    FROM mitpln
                                   WHERE mpl_date = _anfd + i
                                     AND mpl_minr = new.mpl_minr
                                )
                        THEN
                            --
                            IF ( date_to_yearmonth_dec(_anfd + i) > coalesce(_buchmonth, 0) ) THEN
                                --nur eintragen wenn dieser monat noch nicht verbucht
                                INSERT INTO mitpln (mpl_date, mpl_minr) VALUES (_anfd + i, new.mpl_minr);

                                -- Es gibt keine Standardabwesenheit.
                                IF      _llab IS NOT NULL
                                    AND NOT EXISTS(
                                          SELECT true
                                          FROM feiertag
                                          WHERE ft_date = _anfd + i
                                            AND NOT ft_urlaub
                                        )
                                THEN
                                    -- Es darf noch keine Abwesenheit geben an diesem Tag.
                                    IF      NOT EXISTS(
                                              SELECT true
                                              FROM bdepab
                                              WHERE _anfd + i BETWEEN bdab_anf AND bdab_end
                                            )
                                        AND NOT EXISTS(
                                              SELECT true
                                              FROM feiertag
                                              WHERE ft_date = _anfd + i
                                                AND NOT ft_urlaub
                                            )
                                    THEN
                                        INSERT INTO bdepab (bdab_anf, bdab_end, bdab_minr,    bdab_aus_id)
                                        VALUES             (_anfd + i, _anfd + i, new.mpl_minr, _llab);
                                    END IF;

                                    -- Dadurch wird auch ein mitpln satz eingefügt
                                    PERFORM tpersonal.mitpln__saldo__recalc__prsz_neu(_anfd + i, _anfd + i, new.mpl_minr::VARCHAR);
                                END IF;
                            END IF;

                            _outdate := _anfd + i;
                        END IF;
                    END IF;
                END LOOP;
            END IF;

            RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER mitpln__a_iu
        AFTER INSERT OR UPDATE
        ON mitpln
        FOR EACH ROW
        EXECUTE PROCEDURE mitpln__a_iu();
--

--
CREATE OR REPLACE FUNCTION mitplnbeforedel() RETURNS TRIGGER AS $$
  BEGIN
    IF  EXISTS(
          SELECT true
           FROM bdep
          WHERE bd_minr = old.mpl_minr
            AND bd_individwt_mpl_date = old.mpl_date
        )
    THEN
        RAISE EXCEPTION 'cannot delete mitpln, bdep exists: %', Format(lang_text(29202), old.mpl_date); -- Stempelung vorhanden am "%"
    END IF;

    RETURN old;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER mitplnbeforedel
    BEFORE DELETE
    ON mitpln
    FOR EACH ROW
    EXECUTE PROCEDURE mitplnbeforedel();
--

-- Karenzzeiten
CREATE TABLE karenz
  (kr_id                SERIAL PRIMARY KEY,
   kr_anf               TIME(0) WITHOUT TIME ZONE,
   kr_end               TIME(0) WITHOUT TIME ZONE,
   kr_newtime           TIME(0) WITHOUT TIME ZONE,
   kr_tpl_name          VARCHAR(20) REFERENCES tplan ON UPDATE CASCADE,
   CONSTRAINT xtt5037 CHECK(kr_anf<kr_end)
  );

 CREATE OR REPLACE FUNCTION karenz__b_iu() RETURNS TRIGGER AS $$
 BEGIN
  IF (SELECT true FROM karenz WHERE (kr_id<>new.kr_id) AND (COALESCE(kr_tpl_name, '')=COALESCE(new.kr_tpl_name, '')) AND (kr_anf BETWEEN new.kr_anf AND new.kr_end OR kr_end BETWEEN new.kr_anf AND new.kr_end OR (kr_anf<new.kr_anf AND kr_end>new.kr_end)) LIMIT 1)=TRUE THEN
        RAISE EXCEPTION 'xtt5042 another karenz has this time already';
  END IF;
  RETURN new;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER karenz__b_iu
 BEFORE INSERT OR UPDATE
 ON karenz
 FOR EACH ROW
 EXECUTE PROCEDURE karenz__b_iu();


 CREATE TYPE TPersonal.stundauszahl__type AS ENUM(
    'invalid',
    'hours',
    'holidays'
    );

 --Überstunden-/Urlaubsauszahlung beim Monatsabschluss
 CREATE TABLE stundauszahl
  (sa_id                serial  PRIMARY KEY,
   sa_date              date    NOT NULL DEFAULT current_date,
   sa_bez               text,
   sa_minr              integer NOT NULL REFERENCES llv,
   sa_stunden           numeric NOT NULL DEFAULT 0, -- Wird vorgefüllt: Gesamtsumme aus Sonntagsstunden, Feiertagsstunden, Nachtstunden und beantragten Stunden -> Summe der möglichen Auszahlung von Stunden bei automatischer Beantragung
                                                     -- hält dann am Ende mit dem Verbuchen die tatsächlich ausbezahlten Stunden
   sa_antrag            numeric NOT NULL DEFAULT 0, --Beantragung #9605
   sa_sonntag           numeric NOT NULL DEFAULT 0, --Sonntagsstunden #9566
   sa_feiertag          numeric NOT NULL DEFAULT 0, --Feiertagsstunden #9566
   sa_nacht             numeric NOT NULL DEFAULT 0, --Nachtstunden #9566
   sa_normal            numeric NOT NULL DEFAULT 0, --Normalstunden #9566
   sa_urlaub            numeric NOT NULL DEFAULT 0, --Anzahl Urlaubstage #5106 Auszahlung von Urlaub
   sa_type              TPersonal.stundauszahl__type DEFAULT 'invalid'::TPersonal.stundauszahl__type NOT NULL,
   sa_buch              boolean NOT NULL DEFAULT false,

   CONSTRAINT type_valid CHECK (   (sa_type = 'hours'    AND sa_urlaub  = 0)
                                OR (sa_type = 'holidays' AND sa_stunden = 0)
                                )
  );


  CREATE UNIQUE INDEX stundauszahl__minr__month__unique__type  ON stundauszahl (sa_minr, date_to_yearmonth(sa_date), sa_type);

-- #9566 Gesamt Stundenauszahlung aus Einzelsalden berechnen
-- #9566 Verhindern, dass mehr als 1 Datensatz Überstundenauszahlung pro Monat eingefügt wird
-- #9951 Hinweis, wenn automatische Berechnung manuell verändert wird
-- #11642 Zusammenführung
-- #12954, #13180, #11976 Überarbeitung und abrunden der Funktionalität und Usability
CREATE OR REPLACE FUNCTION stundauszahl__b_iu() RETURNS TRIGGER AS $$
    DECLARE isStd boolean; --ist dies ein Stunden-Datensatz
    BEGIN
        isStd := (new.sa_stunden  <> 0) OR (new.sa_sonntag  <> 0) OR (new.sa_feiertag  <> 0) OR (new.sa_nacht  <> 0) OR (new.sa_antrag <> 0);

        IF TG_OP = 'UPDATE' THEN
            -- Verbuchte Datensätze nicht ändern, aber zulassen, das sich sa_buch ändern kann.
            IF new.sa_buch AND new.sa_buch IS NOT DISTINCT FROM old.sa_buch THEN
                RETURN NULL;
            END IF;

            IF isStd THEN
                -- Gesamt Stundenauszahlung aus Einzelsalden berechnen
                IF  old.sa_stunden = new.sa_stunden
                    AND (
                         new.sa_sonntag   <> old.sa_sonntag
                      OR new.sa_feiertag  <> old.sa_feiertag
                      OR new.sa_nacht     <> old.sa_nacht
                      OR new.sa_antrag    <> old.sa_antrag
                    )
                THEN
                    new.sa_stunden := new.sa_sonntag + new.sa_feiertag + new.sa_nacht + new.sa_antrag;
                END IF;

                -- Dialog automatische Berechnung überschreiben #9951
                IF  TSystem.Settings__GetBool('BDE_Ueberstundenauszahlung')
                    AND (
                      SELECT
                           coalesce(ssaldo, 0) <> coalesce(new.sa_sonntag, 0)
                        OR coalesce(fsaldo, 0) <> coalesce(new.sa_feiertag, 0)
                        OR coalesce(nsaldo, 0) <> coalesce(new.sa_normal, 0)
                      FROM tpersonal.llv__mitpln__uebersalden__get(new.sa_minr, new.sa_date)
                    )
                THEN
                    PERFORM PRODAT_TEXT(25441); -- Hinweis : Sie verändern die automatische Berechnung der Überstunden
                    -- RAISE EXCEPTION '%', 'JM';
                END IF;
            END IF;
        END IF;

        IF TG_OP = 'INSERT' THEN
            -- Gesamt Stundenauszahlung aus Einzelsalden berechnen
            IF new.sa_stunden = 0 THEN
                new.sa_stunden := new.sa_sonntag + new.sa_feiertag + new.sa_nacht + new.sa_antrag;
            END IF;

            -- Abwärtskompatibilität: versuchen anhand des Status des Datensatzes den Typ festzustellen, wenn dieser nicht gesetzt wurde
            IF     isStd AND NullIf(new.sa_type, 'invalid') IS null THEN
                new.sa_type := 'hours';
            END IF;

            IF NOT isStd AND NullIf(new.sa_type, 'invalid') IS null THEN
                new.sa_type := 'holidays';
            END IF;
            --

            -- Verhindern, dass mehr als 1 Datensatz Überstundenauszahlung pro Monat eingefügt wird
            IF  isStd
                AND EXISTS(
                  SELECT true FROM stundauszahl
                   WHERE sa_minr = new.sa_minr
                     AND date_to_yearmonth(sa_date) = date_to_yearmonth(new.sa_date)
                     AND sa_type = 'hours'
                )
            THEN
                --IF ((SELECT SUM(sa_stunden) FROM stundauszahl WHERE sa_minr=new.sa_minr AND date_to_yearmonth(sa_date)=date_to_yearmonth(new.sa_date)) <> 0) AND (new.sa_stunden <> 0) THEN
                RAISE EXCEPTION 'stundauszahl exists sa_stunden type hours xtt25434'; --Es kann nur eine Überstundenauszahlung für den gleichen Monat eingetragen werden; PERFORM PRODAT_ERROR(25434) geht meistens nicht
                RETURN NULL;
            END IF;

            -- Verhindern, dass mehr als 1 Datensatz für Urlaubsauszahlung pro Monat eingefügt wird.
            IF  NOT isStd
                AND EXISTS(
                  SELECT true FROM stundauszahl
                   WHERE sa_minr = new.sa_minr
                     AND date_to_yearmonth(sa_date) = date_to_yearmonth(new.sa_date)
                     AND sa_type = 'holidays'
                )
            THEN
                --IF ((SELECT SUM(sa_urlaub) FROM stundauszahl WHERE sa_minr=new.sa_minr AND date_to_yearmonth(sa_date)=date_to_yearmonth(new.sa_date)) <> 0) AND (new.sa_urlaub <> 0) THEN
                RAISE EXCEPTION 'stundauszahl exists sa_urlaub type urlaub xtt30197'; -- Es ist nur eine Urlaubsauszahlung pro Monat zulässig.
                RETURN NULL;
            END IF;
        END IF;

        RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER stundauszahl__b_iu
      BEFORE INSERT OR UPDATE
      ON stundauszahl
      FOR EACH ROW
      EXECUTE PROCEDURE stundauszahl__b_iu();


CREATE OR REPLACE FUNCTION stundauszahl__a_iu() RETURNS TRIGGER AS $$
    BEGIN

        -- ungültige Datensätze verwerfen
        -- Beachte: stundauszahl__b_iu:  new.sa_stunden := new.sa_sonntag + new.sa_feiertag + new.sa_nacht + new.sa_antrag;
        -- Beachte auch: llv__stundauszahl__beantragung__create -> suche dort nach stundauszahl__a_iu
        -- Das ganze findet so statt, da sonst während der Datenanlage mehrfach hinzugefügt und gelöscht würde. Kein guter Ablauf, müßte auf Status umgebaut werden!!! Das Flag, das Stunden 0 eine Urlaubsauszahlung ist durch Datenzustand abzubilden ist schlecht.
        IF    (new.sa_urlaub  = 0 AND new.sa_type = 'holidays')
           OR (new.sa_stunden = 0 AND new.sa_type = 'hours')
        THEN
           DELETE FROM stundauszahl WHERE sa_id = new.sa_id;
        END IF;

        RETURN new;

    END $$ LANGUAGE plpgsql;

    CREATE CONSTRAINT TRIGGER stundauszahl__a_iu
      AFTER INSERT OR UPDATE
      ON stundauszahl
      FOR EACH ROW
      EXECUTE PROCEDURE stundauszahl__a_iu();
--

--Qualifikationsmanagement
CREATE TABLE mitarbrollen
 (mar_id                SERIAL PRIMARY KEY,
  mar_descr             VARCHAR(200) --Rollenbezeichnung DDA
 );

/* Rolle 'Alle Mitarbeiter' darf nicht gelöscht werden, da jedem Mitarbeiter automatisch zugeordnet */
CREATE OR REPLACE FUNCTION mitarbrollen__b_du() RETURNS TRIGGER AS $$
BEGIN
        RAISE EXCEPTION 'xtt15706';
END $$ LANGUAGE plpgsql;

CREATE TRIGGER mitarbrollen__b_du
 BEFORE DELETE OR UPDATE
 OF mar_id
 ON mitarbrollen
 FOR EACH ROW
 WHEN (old.mar_id IN (0))
EXECUTE PROCEDURE mitarbrollen__b_du();


CREATE TABLE rollenprofil
 (rp_id                 SERIAL PRIMARY KEY,
  rp_mar_id             INTEGER REFERENCES mitarbrollen,
  rp_ak_nr              VARCHAR(40) REFERENCES art ON UPDATE CASCADE --Artikel-Nr.
 );

CREATE TABLE mitarbrollenstru           --Baumstruktur, zB Buchhalter enthält Bürotussi, Sekretärin enthält ebenso Bürotussi
 (mart_id               SERIAL PRIMARY KEY,
  mart_mar_id           INTEGER NOT NULL,
  mart_parent_id        INTEGER,
  mart_pos              INTEGER NOT NULL DEFAULT 1 -- TODO durch Funktion ersetzen, die Position richtig vergibt
 );

--CREATE UNIQUE INDEX mitarbrollenstru_unqique_main_rolle ON mitarbrollenstru(mart_mar_id) WHERE mart_parent_id IS NULL;

/* Verhindern, dass Rolle 'Alle Mitarbeiter' eingefügt wird und somit nicht struktiert werden kann - Diese Rolle muss nicht extra als Unterelement in jede Rolle */
CREATE OR REPLACE FUNCTION mitarbrollenstru__b_i() RETURNS TRIGGER AS $$
BEGIN
        RAISE EXCEPTION 'xtt15707';
END $$ LANGUAGE plpgsql;

CREATE TRIGGER mitarbrollenstru__b_i
 BEFORE INSERT
 ON mitarbrollenstru
 FOR EACH ROW
 WHEN (new.mart_mar_id = 0)
EXECUTE PROCEDURE mitarbrollenstru__b_i();


CREATE OR REPLACE FUNCTION mitarbrollen_tree(marid INTEGER, parentid INTEGER DEFAULT NULL) RETURNS SETOF INTEGER AS $$
DECLARE r RECORD;
        r1 RECORD;
        id INTEGER;
BEGIN
 IF parentid IS NULL THEN -- einstieg, noch nicht rekursiv, dann ermitteln wird erstmal unsere struktur
        RETURN NEXT marid;
        id:=mart_id FROM mitarbrollenstru WHERE mart_mar_id=marid AND mart_parent_id IS NULL; -- wir schauen ob es hierfür eine direkte unterstruktur gibt
 ELSE
        id:=parentid;--wir prüfen eine direkte struktur weiter, der parent wurde übergeben
 END IF;
 --
 FOR r IN SELECT mart_id, mart_mar_id FROM mitarbrollenstru WHERE mart_parent_id=id LOOP
        RETURN NEXT r.mart_mar_id;
        RETURN NEXT mitarbrollen_tree(r.mart_id, r.mart_id);
        --nun prüfen ob diese mitarbeiterrolle wieder eine hauptrolle ist
        FOR r1 IN SELECT * FROM mitarbrollen_tree(r.mart_mar_id) LOOP
                RETURN NEXT r1.mitarbrollen_tree;
        END LOOP;
 END LOOP;
 RETURN;
END $$ LANGUAGE plpgsql STABLE;


--bis hier Mitarbeiterrollen, zB Facharbeiter sowie Stuktur/Baumaufbau von Strukturen

-- Beschreibung Qualifikation gruppiert nach AC
CREATE TABLE skill
 (skill_id              SERIAL PRIMARY KEY,
  skill_key             VARCHAR(20), -- Schlüsselfeld für Reports
  skill_descr           VARCHAR(75),
  skill_ak_ac           VARCHAR(9) NOT NULL REFERENCES artcod ON UPDATE CASCADE
 );

-- Bewertungen //ak_ac für Filter der Bewertungen einer Gruppe
CREATE TABLE skillbew
 (sbw_id                SERIAL PRIMARY KEY,
  sbw_note              INTEGER, -- Schulnote
  sbw_descr             VARCHAR(75),
  sbw_ak_ac             VARCHAR(9) NOT NULL REFERENCES artcod ON UPDATE CASCADE
 );


-- Neue Tabelle für Schulungen
CREATE TABLE skillplan(
  skp_id SERIAL PRIMARY KEY,
  skp_due DATE, -- Durchführung notwendig bis ~ Zeitraum, in dem die Schulung wiederholt werden muss
  skp_ak_nr VARCHAR(40) REFERENCES art ON UPDATE CASCADE, -- Artikel-Nr. Qualifikation
  skp_lkn VARCHAR(21) REFERENCES adk ON UPDATE CASCADE -- Druchführung durch externe Organisation, intern
) INHERITS (sysdat);

ALTER TABLE skillplan ALTER COLUMN dat_tablename SET DEFAULT 'skillplan'; --Ursprungsdatensatz direkt übergeben

 -- Legt beim Insert die Default-Parameter für Schulungsplanung an
CREATE TRIGGER skillplan__a_i__create_autoparams
  AFTER INSERT
  ON skillplan
  FOR EACH ROW
EXECUTE PROCEDURE TRecnoParam.CreateAutoParams();
--

--Personalmanagement
--Zuordnung der Mitarbeiterrollen zu Mitarbeitern
CREATE TABLE anfmitarbzu
 (amz_id                SERIAL PRIMARY KEY,
  amz_minr              INTEGER NOT NULL REFERENCES llv ON UPDATE CASCADE ON DELETE CASCADE,
  amz_mar_id            INTEGER NOT NULL REFERENCES mitarbrollen
 );

--Zuordnung Qualifikationen zu Mitarbeiter  //ersetzt mitarbskills
CREATE TABLE skillmitarbzu
 (smz_id                SERIAL PRIMARY KEY,
  smz_minr              INTEGER NOT NULL REFERENCES llv ON UPDATE CASCADE ON DELETE CASCADE,
  smz_ak_nr             VARCHAR(40) REFERENCES art ON UPDATE CASCADE, --Artikel-Nr.
  smz_descr             VARCHAR(100), --Beschreibung
  smz_bdat              DATE,   --Erworben am
  smz_edat              DATE,   --Gültig bis
  smz_erfgrad           NUMERIC(5,2), -- Erfüllungsgrad in %
  smz_theorie           BOOLEAN DEFAULT FALSE, -- für Lehrgänge: Ist Theorie abgeschlossen?
  smz_praxis            BOOLEAN DEFAULT FALSE,
  smz_prufung           BOOLEAN DEFAULT FALSE, --NOT NULL,
  smz_bewert_id         INTEGER REFERENCES skillbew, --Bewertung: Wie gut? Bsp: "Schriftlich: Gut, Mündlich: Fließend"
  smz_vergabevon        VARCHAR(80), --Wer hat geschult/beglaubigt etc?!? Bsp: Volkshochschule Dresden
  smz_lkn               VARCHAR(21) REFERENCES adk ON UPDATE CASCADE, --
  smz_txt               TEXT --Zusatztext
 );


--Art der Anstellung Subtabelle
CREATE TABLE anstellart
 (arta_id               SERIAL PRIMARY KEY,
  arta_descr            VARCHAR(200) --Art der Anstellung
 );

CREATE TABLE persgruppe
 (persg_id              SERIAL PRIMARY KEY,
  persg_descr           VARCHAR(200)
 );

--Todo-Liste Peronalmgmt

CREATE TABLE perskatdescr
 (pkd_id                SERIAL PRIMARY KEY,
  pkd_descr             VARCHAR(200)
 );

CREATE TABLE todoperskat
 (tdk_id                SERIAL PRIMARY KEY,
  tdk_pkd_id            INTEGER REFERENCES perskatdescr,--Kategorie ID
  tdk_task              VARCHAR(300),                   --Aufgabe
  tdk_zust              VARCHAR(50),                    --Zuständigkeit
  tdk_txt               TEXT,                           --Zusatztext
  tdk_txt_rtf           TEXT
 );

CREATE TABLE todopers
 (tdp_id                SERIAL PRIMARY KEY,
  tdp_minr              INTEGER NOT NULL REFERENCES llv ON UPDATE CASCADE,
  tdp_pkd_id            INTEGER REFERENCES perskatdescr,--Kategorie ID
  tdp_task              VARCHAR(300),                   --wird kopiert aus tdk_task
  tdp_bdat              DATE,                           --Beginn am
  tdp_edat              DATE,                           --Beendet am
  tdp_zust              VARCHAR(50),                    --Zuständigkeit
  tdp_txt               TEXT,                           --Zusatztext
  tdp_txt_rtf           TEXT
 );



--Mitarbeiterstamm
CREATE TABLE personal
 (pers_id               SERIAL PRIMARY KEY,
  pers_krz              VARCHAR(21) NOT NULL REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,
  --personaldaten verschleiern
  pers_str              VARCHAR(75),--**entsprechende Felder aus adk
  pers_plz              VARCHAR(30),
  pers_ort              VARCHAR(50),
  pers_bem              VARCHAR(60),
  pers_landiso          VARCHAR(5) REFERENCES laender ON UPDATE CASCADE,
  pers_land             VARCHAR(50),
  pers_tel2             VARCHAR(50),-- Telefon privat
  pers_tel2_f           BOOLEAN DEFAULT False, -- Telefon privat Freigabe im Telefonverzeichnis
  pers_mobilpriv        VARCHAR(50),-- Mobiltelefon privat
  pers_mobilpriv_f      BOOLEAN DEFAULT False, --Mobiltelefon privat Freigabe im Telefonverzeichnis
  pers_faxpriv          VARCHAR(50),--Fax privat
  pers_email2           VARCHAR(50),--Email privat ** Ende entsprechende Felder aus adk
  --personaldaten verschleiern
  pers_titel            VARCHAR(20), --Titel
  pers_mname            VARCHAR(27), --2. Vorname
  pers_gname            VARCHAR(27), --Geburtsname
  pers_gort             VARCHAR(50), --Geburtsort
  pers_gland            VARCHAR(50), --Geburtsland
  pers_staatsang        VARCHAR(50), --Staatsangehörigkeit
  pers_persg_id         INTEGER REFERENCES persgruppe, -- Gruppe
  pers_sprache          VARCHAR(50), --Sprache
  pers_gesch            VARCHAR(20), --Geschlecht
  pers_stand            VARCHAR(20), --Familienstand
  pers_kinder           INTEGER DEFAULT 0, --Anzahl Kinder
  pers_steuer           INTEGER, --Steuerklasse
  pers_kirche           VARCHAR(100),
  pers_probezeit        DATE, --Ende Probezeit
  pers_vertrauensp       INTEGER REFERENCES llv ON DELETE CASCADE,--Vertrauensperson
  pers_vertretung1       INTEGER REFERENCES llv ON DELETE CASCADE,--1.Vertreter
  pers_vertretung2       INTEGER REFERENCES llv ON DELETE CASCADE,--2.Vertreter
  pers_stellenbez       VARCHAR(200),--     Stellenbezeichnung
  pers_vertrag          VARCHAR(100), --Vertrag, Art des Vertrags z.b. Tarifvertrag
  pers_bgrad            NUMERIC(5,2) NOT NULL DEFAULT 100, --Beschäftiugngsgrad statisch - der BG zum dem der Mitarbeiter eingestellt ist - diesen nicht ändern wegen Kurzarbeit
  pers_hpw              NUMERIC(5,2), -- Stunden pro Woche für Gehaltsempfänger
  pers_stdlohn          NUMERIC(5,2), -- Stundenlohn
  pers_mlohn            NUMERIC(9,2), -- Monatslohn
  pers_arta_id          INTEGER REFERENCES anstellart, -- Art der Anstellung
  pers_entgelt          VARCHAR(10),  -- Art des Arbeitsentgelts
  pers_bknr             VARCHAR(50),
  pers_blz              VARCHAR(30),
  pers_bank             VARCHAR(60),
  pers_bic              VARCHAR(50),
  pers_iban             VARCHAR(50),
  pers_sv               VARCHAR(50), --Sozialversicherungs-Nummer
  pers_rv               VARCHAR(50), --Rentenversicherungs-Nummer
  pers_kv               VARCHAR(21) REFERENCES adk ON UPDATE CASCADE, --Krankenversicherung
  pers_kranken_vnr      VARCHAR(20), -- Krankenversicherungs-Nummer (1 Buchstabe + 9 Ziffern[statisch] + x Ziffern intern + Prüfziffer)
  pers_letztearbeit     VARCHAR(21) REFERENCES adk ON UPDATE CASCADE, --Letzte Arbeitsstelle
  pers_fschein          VARCHAR(100), --Führerscheine
  pers_fscheinweg       BOOLEAN DEFAULT FALSE, --Führerschein ist weg
  pers_befristet        BOOLEAN DEFAULT FALSE, --Anstellung ist befristet
  pers_beruf            VARCHAR(100), --erlernter Beruf / Ausbildung als
  pers_aufhalt          DATE, --Aufenthaltsgenehmigung bis Datum
  pers_raucher          BOOLEAN DEFAULT False, --Raucher
  --pers_ksteuer                BOOLEAN DEFAULT False, --kirchensteuerpflichtig
  pers_info             TEXT, --Bemerkungen
  pers_info_rtf         TEXT,
  pers_allg1            VARCHAR(50),
  pers_allg2            VARCHAR(50),
  pers_allg3            VARCHAR(50),
  pers_allg4            VARCHAR(50),
  pers_allg5            VARCHAR(75),
  pers_allg6            VARCHAR(75)

 );

CREATE INDEX personal_pers_vertretung1 ON personal(pers_vertretung1);
CREATE INDEX personal_pers_vertretung2 ON personal(pers_vertretung2);
CREATE UNIQUE INDEX personal_pers_krz ON personal(pers_krz);

--
CREATE OR REPLACE FUNCTION personal__b_i() RETURNS TRIGGER AS $$
  BEGIN
    -- Wenn Mitarbeiter über Adressverzeichnis angelegt wurde, werden Adressdaten ins Personal übertragen
    IF EXISTS(SELECT true FROM adk WHERE ad_krz = new.pers_krz) THEN
        SELECT     ad_str,       ad_plz,       ad_ort,       ad_landiso,       ad_land,       ad_tel2,       ad_mobilpriv,       ad_faxpriv,       ad_email2
        INTO new.pers_str, new.pers_plz, new.pers_ort, new.pers_landiso, new.pers_land, new.pers_tel2, new.pers_mobilpriv, new.pers_faxpriv, new.pers_email2
        FROM adk WHERE ad_krz = new.pers_krz;

        IF (EXISTS(SELECT true FROM adk1 WHERE a1_krz = new.pers_krz) OR -- Debitorendaten sind vorhanden
            EXISTS(SELECT true FROM adk2 WHERE a2_krz = new.pers_krz) OR -- Kreditorendaten sind vorhanden
            EXISTS(SELECT true FROM adk WHERE ad_krz = new.pers_krz AND ad_fa1 IS NOT NULL) -- Firma ist angg.
           ) THEN
           PERFORM PRODAT_TEXT(lang_text(16429) || new.pers_krz); -- Hinweis, dass evtl. Firmenadresse genommen wird und Adressdaten nicht unkenntlich gemacht werden, siehe #4564.
        END IF;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER personal__b_i
    BEFORE INSERT
    ON personal
    FOR EACH ROW
    EXECUTE PROCEDURE personal__b_i();
--

--
CREATE OR REPLACE FUNCTION personal__a_iu_adresschange() RETURNS TRIGGER AS $$
  DECLARE pers_rec RECORD;
  BEGIN
    SELECT new.pers_str AS str, new.pers_plz AS plz, new.pers_ort AS ort, new.pers_landiso AS landiso, new.pers_land AS land, new.pers_tel2 AS tel2, new.pers_mobilpriv AS mobilpriv, new.pers_faxpriv AS faxpriv, new.pers_email2 AS email2
    INTO pers_rec;

    -- Schritt 1: Daten unkenntlich machen
        -- 1.1: Telefonnummern unkenntlich machen, wenn nicht freigegeben
        IF NOT new.pers_tel2_f THEN
            pers_rec.tel2:='***';
        END IF;
        IF NOT new.pers_mobilpriv_f THEN
            pers_rec.mobilpriv:='***';
        END IF;

        -- 1.2: immer unkenntlich machen, keine Freigabeoption vorhanden
        pers_rec.faxpriv:='***';
        pers_rec.email2:='***';

        -- 1.3: unkennntlich machen, wenn keine Firmenadresse (adk1 und adk2 existieren nicht, Firma ist nich angg.), siehe #4564
        IF NOT EXISTS(SELECT true FROM adk1 WHERE a1_krz = new.pers_krz) AND -- Debitorendaten vorhanden
           NOT EXISTS(SELECT true FROM adk2 WHERE a2_krz = new.pers_krz) AND -- Kreditorendaten vorhanden
           NOT EXISTS(SELECT true FROM adk WHERE ad_krz = new.pers_krz AND ad_fa1 IS NOT NULL) THEN -- Firma angg.
             pers_rec.str:='***';
             pers_rec.plz:='***';
             pers_rec.ort:='***';
             pers_rec.landiso:=NULL;
             pers_rec.land:=NULL;
        END IF;
    --

    -- Schritt 2: Adresse gemäß unkenntlichen Daten aktualisieren
        Perform TSystem.Settings__Set('AdresseChangedByPersonal', 'T');

        UPDATE adk SET
          ad_str=pers_rec.str,
          ad_plz=pers_rec.plz,
          ad_ort=pers_rec.ort,
          ad_landiso=pers_rec.landiso,
          ad_land=pers_rec.land,
          ad_tel2=pers_rec.tel2,
          ad_mobilpriv=pers_rec.mobilpriv,
          ad_faxpriv=pers_rec.faxpriv,
          ad_email2=pers_rec.email2
        WHERE
          ad_krz=new.pers_krz;

        Perform TSystem.Settings__Set('AdresseChangedByPersonal', 'F');
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER personal__a_iu_adresschange
    AFTER INSERT OR UPDATE OF pers_str, pers_plz, pers_ort, pers_landiso, pers_land, pers_tel2, pers_tel2_f, pers_mobilpriv, pers_mobilpriv_f, pers_faxpriv, pers_email2
    ON personal
    FOR EACH ROW
    EXECUTE PROCEDURE personal__a_iu_adresschange();
--

-- Frage ob Personaldaten wieder zurück in Adressstamm sollen. Sonst gehen Daten verloren.
CREATE OR REPLACE FUNCTION personal__a_d() RETURNS TRIGGER AS $$
  BEGIN
    IF EXISTS(SELECT true FROM adk WHERE ad_krz = old.pers_krz) THEN
        PERFORM PRODAT_MESSAGE_YES_NO(16430, 'Message.personal.delete.yes', NULL,
            COALESCE(old.pers_str, '') || ',' || COALESCE(old.pers_plz, '') || ',' || COALESCE(old.pers_ort, '') || ',' || COALESCE(old.pers_landiso, '') || ',' || COALESCE(old.pers_land, '') || ',' ||
            COALESCE(old.pers_tel2, '') || ',' || COALESCE(old.pers_mobilpriv, '') || ',' || COALESCE(old.pers_faxpriv, '') || ',' || COALESCE(old.pers_email2, '') || ',' || COALESCE(old.pers_krz, ''));
    END IF;
    RETURN old;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER personal__a_d
    AFTER DELETE
    ON personal
    FOR EACH ROW
    EXECUTE PROCEDURE personal__a_d();
--

-- Mitarbeiter deren Vertretung ich bin, oder die ich vertrete (0=alles 1=vertrete ich 2=vertreten mich)
CREATE OR REPLACE FUNCTION personal_Vertretungsbeziehungen(minr INTEGER, Mode INTEGER DEFAULT 0) RETURNS SETOF INTEGER AS $$
  -- ich bin Vertreter von
  SELECT ll_minr FROM personal JOIN llv ON ll_ad_krz = pers_krz WHERE COALESCE(pers_vertretung1, -1) = $1 OR COALESCE(pers_vertretung2, -1) = $1 AND $2 IN (0, 1)
  UNION

  -- mein 1. Vertreter
  SELECT pers_vertretung1 FROM personal JOIN llv ON ll_ad_krz = pers_krz AND ll_minr = $1 WHERE pers_vertretung1 IS NOT NULL AND $2 IN (0, 2)
  UNION

  -- mein 2. Vertreter
  SELECT pers_vertretung2 FROM personal JOIN llv ON ll_ad_krz = pers_krz AND ll_minr = $1 WHERE pers_vertretung2 IS NOT NULL AND $2 IN (0, 2)
$$ LANGUAGE SQL;



CREATE TABLE ExportLohn
 (el_lohnart     INTEGER NOT NULL,
  el_minr        INTEGER NOT NULL,
  el_ks          VARCHAR(9),-- REFERENCES ksv,
  el_abrechdat   DATE,
  el_anztage     NUMERIC(6,2),
  el_anzStunden  NUMERIC(6,2),
  el_expdone     BOOLEAN NOT NULL DEFAULT FALSE,
  el_expdat      DATE,
  el_comment     VARCHAR(100),
  el_hinweis     VARCHAR(200),
  el_status      INTEGER NOT NULL DEFAULT 0,
  el_loa_zusatz   VARCHAR(2) -- Für lohnartenexport benötigtes Feld des Ausfallschlüssel
 );


/*
Stammkostenstelle Ja?   => Keine Auftragszeiten
        => Sollzeit
        => Ausbezahlte Überstunden
        => Alles auf Stammkostenstelle

Stammkostenstelle Nein? => Auftragszeiten stempeln

        => Summe Auftragszeiten
        => Summe Überstunden (ausgezahlte)
        => Summe Nachtstunden
        => Aufteilung Auftragszeit auf Kostenstellen, Auftragszeit < Präsenzzeit + Überstudnen => Buchen auf Kostenstelle 8095

Urlaub, Krankheit, andere Abwesenheiten danach buchen.
Urlaub, Krankheit in Tagen, alles andere in Stunden.

Mitarbeiterumschlüsselung auf ll_allg1

Definierte Lohnarten:

Zeitlohn (Normal):      820
Zeitlohn (Aushilfen):   1607
Überstunden:            2106
Stundenkonto:           899
Nachtstunden:           2630
Krankheit               500
Urlaub                  400
Andere Abwesenheiten    Def. in ab_allg1
*/


-- Überfunktion, dient als Wrapper für den unterschiedlichen Lohnarten-Export
-- entschieden wird auf Basis der dynamischen Settings BDE.LohnUndGehalt.Export.*
CREATE OR REPLACE FUNCTION z_99_deprecated.GetLohnDaten(
    formonth integer,
    minr     integer = null
  ) RETURNS void AS $$

  BEGIN
      PERFORM TPersonal.Lohndaten_export__create( formonth, minr );
      RETURN;
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TPersonal.lohndaten_export__create(
    _formonth integer,
    _minr     integer = null
  ) RETURNS void AS $$
  BEGIN

      IF TSystem.Settings__GetBool( 'BDE.LohnUndGehalt.Export.Addison' ) THEN

          PERFORM TPersonal.lohndaten_export__addison__create( _formonth );

      ELSIF TSystem.Settings__GetBool( 'BDE.LohnUndGehalt.Export.Datev' ) THEN

          PERFORM TPersonal.lohndaten_export__datev__create(
              _formonth,
              _minr,
              string_to_array(
                  TSystem.settings__get( 'BDE.LohnundGehalt.Export.Datev.Abwesenheiten' ),
                  ','
              )::int[]
          );

      ELSE

         RAISE NOTICE 'Kein ausgewählter Export für BDE (möglich aktuell Addison oder Datev)';

      END IF;

      RETURN;

END $$ LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION TPersonal.lohndaten_export__addison__create(formonth INTEGER) RETURNS VOID AS $$
DECLARE abrzeitanf  DATE;
        abrzeitend  DATE;
        mitarbrec   RECORD;
        kstime      RECORD;
        sumaufzeit  NUMERIC;     --Gesamte gestempelte Auftragszeit eines Mitarbeiters im Monat
        anteil      NUMERIC(6,2);--Wg. Summenerhaltendem Runden, damit Summe der Anteile zum Schluß stimmt
        fehler      NUMERIC;     --Wg. Summenerhaltendem Runden, damit Summe der Anteile zum Schluß stimmt
        ueberzeit   NUMERIC;     --Ausgezahlte Überstunden eines Monats
        anteilueb   NUMERIC(6,2);--Wg. Summenerhaltendem Runden, damit Summe der Anteile zum Schluß stimmt
        fehlerueb   NUMERIC;     --Wg. Summenerhaltendem Runden, damit Summe der Anteile zum Schluß stimmt
        nachtZeit   NUMERIC;     --Nachtstunden des Mitarbeiters
        anteilnacht NUMERIC(6,2);--Wg. Summenerhaltendem Runden, damit Summe der Anteile zum Schluß stimmt
        fehlernacht NUMERIC;     --Wg. Summenerhaltendem Runden, damit Summe der Anteile zum Schluß stimmt
        restZeit    NUMERIC;     --Bleibt übrig Rest wenn Präsenz < Auftragszeit < Präsenz+Überstunden
        zeitlohnart INTEGER;     --Lohnart die für Zeitlohn verwendet wird. Normal 1120, für Mitarbeitergruppe Aushilfe aber 2106,
                                 -- Geändert nach Tel.Frau Roth - 08.02.2012, alle Mitarbeitergruppen, die mit "Aushilfe" beginnen.
        hinweis     VARCHAR(200);--Hinweis auf seltsame Daten beim Export
        status      INTEGER;
BEGIN

   --Anfang und Ende des Exportzeitraumes (Volle Tage) Formonth = 201005 => Juni
   abrzeitanf:= CAST((formonth/100) AS VARCHAR) ||'-'|| CAST((formonth%100)+1 AS VARCHAR) || '-01';
   abrzeitend:= abrzeitanf + (('1 month')::INTERVAL) -  (('1 second') :: INTERVAL);

   /***************************************************************************************
   --OHNE STAMMKOSTENSTELLE: Mitarbeiter-Nr/Mitarbeitergruppe und Gesamtprzzeit holen, wenn Monatsabschluss vorliegt und keine Stammkostenstelle vorhanden
   ***************************************************************************************/
   FOR mitarbrec IN SELECT ll_minr, COALESCE(CAST(ll_allg1 AS INTEGER),mpl_minr) AS expminr, ll_grup,
                     MIN(SUM(COALESCE(mpl_Saldo,0)), SUM(IFTHEN(COALESCE(mpl_min,0)=0,COALESCE(mpl_saldo,0),COALESCE(mpl_min,0)))) AS sumprzzeit, ll_auftrzeit
                     FROM mitpln JOIN llv ON mpl_minr = ll_minr
                             WHERE mpl_formonth = formonth
                                AND ll_dolohnexport
                                AND (ll_ks IS NULL )
                                AND EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth)
                                AND ( date_to_yearmonth_dec(ll_einstd) <= formonth)
                                AND ( COALESCE(date_to_yearmonth_dec(ll_endd),formonth+1) >= formonth)
                             GROUP BY ll_minr,expminr,ll_grup,ll_auftrzeit
   LOOP
        --Gesamte gestempelte Auftragszeit eines Mitarbeiters im Monat
        SELECT COALESCE(SUM(ba_efftime),0) INTO sumaufzeit FROM bdea WHERE ba_minr = mitarbrec.ll_minr AND (CAST(ba_anf_rund AS DATE) >= abrzeitanf) AND (CAST(ba_anf_rund AS DATE) <= abrzeitend) AND ba_efftime IS NOT NULL;
        sumaufzeit:=COALESCE(sumaufzeit,0);
        --Ausgezahlte Überstunden für den Mitarbeiter diesen Monat
        SELECT SUM(COALESCE(sa_stunden,0)) INTO ueberzeit  FROM stundauszahl JOIN llv ON sa_minr = ll_minr WHERE Date_To_Yearmonth_Dec(sa_date)=formonth AND sa_buch AND sa_minr = mitarbrec.ll_minr;
        ueberzeit:=COALESCE(ueberzeit,0);
        --Nachtstunden eines Mitarbeiters im Monat
        --SELECT SUM(COALESCE(bd_nachtstunden,0)) INTO nachtZeit FROM bdep WHERE bd_minr = mitarbrec.ll_minr AND (CAST(bd_anf AS DATE) >= abrzeitanf) AND (CAST(bd_end AS DATE) <= abrzeitend) AND bd_nachtstunden IS NOT NULL;
        SELECT SUM(COALESCE(bd_nachtstunden,0)) INTO nachtZeit FROM bdep WHERE bd_minr = mitarbrec.ll_minr AND (CAST(bd_anf AS DATE) >= abrzeitanf) AND (CAST(bd_anf AS DATE) <= abrzeitend) AND bd_nachtstunden IS NOT NULL;
        nachtzeit:=COALESCE(nachtzeit,0);
        --Welche Lohnart bekommt Mitarbeiter für Zeitlohn?
        zeitlohnart:=IfThen((UPPER(mitarbrec.ll_grup) LIKE 'AUSHILFE%'),1607,820);

        --raise notice  'Minr: % - Sumaufzeit: % - Sumprzz: % ', mitarbrec.expminr, sumaufzeit, mitarbrec.sumprzzeit;

        /***************************************************************************************
                Plausibilitätsprüfung, ob unsere Daten wenigstens halbwegs Sinn ergeben.
        ***************************************************************************************/
        hinweis:=NULL;

        IF (mitarbrec.sumprzzeit>0) THEN
                IF ((sumaufzeit / mitarbrec.sumprzzeit) < 0.25) THEN
                        hinweis := lang_text(29203) /*'Hinweis: Weniger als 25 % der Präsenzzeit sind als Auftragszeit erfasst.'*/;
                        status:=0;
                END IF;
        END IF;

        IF (sumaufzeit=0) THEN
                hinweis := lang_text(29204) /*'Keine Auftragszeit vorhanden, obwohl Mitarbeiter laut Stammdaten stempeln soll. Keine KS-Aufteilung moeglich.'*/;
                status:=2;
        END IF;
        IF (NOT mitarbrec.ll_auftrzeit) THEN
                hinweis := lang_text(29205) /*'Stempeln der Auftragszeit in Stammdaten deaktiviert, aber Stammkostenstelle nicht angegeben.'*/;
                status:=2;
        END IF;
        IF (mitarbrec.sumprzzeit=0) THEN
                hinweis := lang_text(29206) /*'Gefundene Praesenzzeit ist 0.'*/;
                status:=2;
        END IF;
        /***************************************************************************************
        Auftragszeit-Stunden der einzelnen Kostenstellen, Über den Monat aufsummiert, Einmal durchlaufen und aufteilen
        ***************************************************************************************/
        fehler:=0;
        fehlerueb:=0;
        fehlernacht:=0;
        restZeit:= COALESCE(sumaufzeit-mitarbrec.sumprzzeit,0);--Soviel mehr Auftragszeit als Präsenzzeit gibt es
        FOR kstime IN SELECT sum(ba_efftime) AS aufzeitks, COALESCE(ks_allg1, ba_ks) AS ba_ks FROM bdea JOIN ksv ON ba_ks = ks_abt
                                WHERE ba_minr = mitarbrec.ll_minr AND (CAST(ba_anf_rund AS DATE) >= abrzeitanf) AND (CAST(ba_anf_rund AS DATE) <= abrzeitend)
                                        AND ba_efftime IS NOT NULL GROUP BY ba_ks, ks_allg1
        LOOP
                --Bei Auftragszeit <= Präsenzzeit ====> aufteilen, nach Schleife Restzeit auffüllen mit KS 8095 (Ohne Zuordnung)
                IF (sumaufzeit <= mitarbrec.sumprzzeit) AND (mitarbrec.sumprzzeit > 0) THEN
                    --raise notice  'AufZeit-Voll - KS: % - Stu.: % ', kstime.ba_ks, kstime.aufzeitks;
                    INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment) VALUES (zeitlohnart,mitarbrec.expminr, kstime.ba_ks,abrzeitanf,kstime.aufzeitks,lang_text(29207) /*'Auftragszeit absolut auf KS'*/);
                END IF;
                --Auftragszeit > Präsenzzeit => anteilig auf Präsenzzeit verteilen
                IF (sumaufzeit > mitarbrec.sumprzzeit) AND (mitarbrec.sumprzzeit > 0) THEN  --Wenn SumAufzeit NULL => IF (False) => Daher keine Division durch 0 moeglich
                    --raise notice  'AufZeit-Anteil - KS: % - Stu: % - StuAnteil: % ', kstime.ba_ks, kstime.aufzeitks,((kstime.aufzeitks*mitarbrec.sumprzzeit) / sumaufzeit);
                    anteil:=(fehler + ((kstime.aufzeitks*mitarbrec.sumprzzeit) / sumaufzeit));
                    fehler:=((kstime.aufzeitks*mitarbrec.sumprzzeit) / sumaufzeit)-anteil;
                    INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment) VALUES (zeitlohnart,mitarbrec.expminr, kstime.ba_ks,abrzeitanf,anteil,lang_text(29208) /*'Auftragszeit anteilig auf KS'*/);

                    --Es gibt Überstunden => dann auch anteilig auf Kostenstellen der Auftragszeit verteilen
                    IF (ueberzeit > 0) THEN
                        --Mehr Überstunden als noch zu verteilende Auftragszeit (Bsp. Prszzeit 160, Überstunden 20, Auftragszeit 170), da bleiben Überstunden ohne Zuordnung übrig
                        If (ueberzeit > restZeit) THEN
                          anteilueb:=(fehlerueb+((kstime.aufzeitks*restZeit) / sumaufzeit));
                          fehlerueb:=(((kstime.aufzeitks*restZeit) / sumaufzeit)-anteilueb);
                          INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment) VALUES (2106,mitarbrec.expminr, kstime.ba_ks,abrzeitanf,anteilueb,lang_text(29209) /*'Ueberstunden absolut auf KS'*/);
                        ELSE --Hier ist soviel Auftragszeit, das Präsenz+Überstunden nicht ausreichen. Daher alles aufteilen.
                          --RAISE NOTICE  'UeberstAnteil - KS: % - Stu: % - StuAnteil: % ', kstime.ba_ks, kstime.aufzeitks,((kstime.aufzeitks*ueberzeit) / sumaufzeit);
                          anteilueb:=(fehlerueb+((kstime.aufzeitks*ueberzeit) / sumaufzeit));
                          fehlerueb:=(((kstime.aufzeitks*ueberzeit) / sumaufzeit)-anteilueb);
                          INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment) VALUES (2106,mitarbrec.expminr, kstime.ba_ks,abrzeitanf,anteilueb,lang_text(29210) /*'Ueberstunden anteilig auf KS'*/);
                        END IF;
                    END IF;
                END IF;
                --
                IF ( (nachtZeit > 0 ) AND (sumaufzeit > 0) )THEN  --Wenn SumAufzeit = NULL => IF (False) => Daher keine Division durch 0 moeglich
                    anteilNacht:=(fehlernacht+((kstime.aufzeitks*nachtzeit)/sumaufzeit));
                    fehlernacht:=(((kstime.aufzeitks*nachtzeit)/sumaufzeit)-anteilnacht);
                    INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment) VALUES (2630,mitarbrec.expminr, kstime.ba_ks,abrzeitanf,anteilNacht,lang_text(29211) /*'Nachtstunden anteilig auf KS'*/);
                END IF;
        --
        END LOOP;
        --Restzeit auffüllen mit KS 8095 (Ohne Zuordnung), Weniger Auftragszeit als Präsenz+Überstunden? Dann bleibt was übrig.
        IF (sumaufzeit < (mitarbrec.sumprzzeit+ueberzeit)) THEN

            --Auftragszeit kleiner Präsenzzeit => Auftragszeitrest und Überstunden auf 'Ohne Zuordnung'
            IF (sumaufzeit < mitarbrec.sumprzzeit) THEN
              INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment) VALUES (zeitlohnart,mitarbrec.expminr, 8095 ,abrzeitanf,(mitarbrec.sumprzzeit-sumaufzeit),lang_text(29212) /*'Praesenzzeit-Differenz, ohne Zuordnung'*/);
              --Überstunden dann auch ohne Zuordnung, da Auftragszeit ja schon weg
              IF (ueberzeit > 0) THEN
                --RAISE NOTICE  'Ueberstunden-Differenz: KS: % - UeberStu: % ', 8095,  ueberzeit;
                INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment) VALUES (2106,mitarbrec.expminr, 8095,abrzeitanf,ueberzeit,lang_text(29213) /*'Ueberstunden, ohne Zuordnung'*/);
              END IF;
            ELSE
              --Auftragszeit ist größer als Präsenzzeit => Können nur Überstunden übrig sein.
              IF (ueberzeit > 0) THEN
              --RAISE NOTICE  'Ueberstunden-Differenz: KS: % - UeberStu: % ', 8095,  ueberzeit;
                INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment) VALUES (2106,mitarbrec.expminr, 8095,abrzeitanf,(mitarbrec.sumprzzeit+ueberzeit-sumaufzeit),lang_text(29213) /*'Ueberstunden, ohne Zuordnung'*/);
              END IF;
            END IF;
        END IF;
        --
        IF (hinweis IS NOT NULL) THEN
            INSERT INTO exportlohn (el_lohnart,el_minr, el_abrechdat, el_expdone, el_comment, el_hinweis, el_status) VALUES (0,mitarbrec.expminr,abrzeitanf, true , lang_text(13629) /*'Exporthinweis'*/, hinweis, status);
        END IF;
   END LOOP;


   --***************************************************************************************
   -- Stundensaldo und Überstunden, wenn Mitarbeiter Stammkostenstelle => Ohne Aufteilungen
   --***************************************************************************************

   -- Stundensaldo aus Mitplan, Maximal Soll-Arbeitszeit => Überstunden separat, Bleibt einziger Eintrag für Mitarbeiter mit Stammkostenstelle
   INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment)
        SELECT  IfThen((UPPER(ll_grup) LIKE 'AUSHILFE%'),1607,820),                    --Lohnarten für Aushilfen ist 2106 statt 1120
                COALESCE(CAST(ll_allg1 AS INTEGER),mpl_minr) AS minr, ll_ks,abrzeitAnf,
                MIN(SUM(COALESCE(mpl_Saldo,0)), SUM(IFTHEN(COALESCE(mpl_min,0)=0,COALESCE(mpl_saldo,0),COALESCE(mpl_min,0)))),
                'Stundensaldo auf Stammkostenstelle'
                  FROM mitpln JOIN llv ON mpl_minr = ll_minr
                  WHERE mpl_formonth = formonth
                        AND EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth)
                        AND ll_dolohnexport
                        AND (ll_ks IS NOT NULL)
                        AND ( date_to_yearmonth_dec(ll_einstd) <= formonth)
                        AND ( COALESCE(date_to_yearmonth_dec(ll_endd),formonth+1) >= formonth)
          GROUP BY minr,ll_ks,ll_grup ORDER BY minr;

   -- Überstunden
   INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment)
        SELECT 2106, COALESCE(CAST(ll_allg1 AS INTEGER),sa_minr) AS minr, ll_ks,abrzeitAnf,SUM(COALESCE(sa_stunden,0)), lang_text(29214) /*'Ueberstunden auf Stammkostenstelle'*/
                  FROM stundauszahl JOIN llv ON sa_minr = ll_minr
           WHERE Date_To_Yearmonth_Dec(sa_date)=formonth
                 AND sa_buch AND EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth)
                 AND ll_dolohnexport
                 AND (ll_ks IS NOT NULL)
                 AND ( date_to_yearmonth_dec(ll_einstd) <= formonth)
                 AND ( COALESCE(date_to_yearmonth_dec(ll_endd),formonth+1) >= formonth)
        GROUP BY minr,ll_ks ORDER BY minr;
   DELETE FROM exportlohn WHERE el_anzstunden < 0 AND el_lohnart = 2106;


   --***************************************************************************************
   -- Stundenkonto und Nachtstunden
   --***************************************************************************************

   -- Verbuchtes Stundenkonto aus llv
   INSERT INTO exportlohn(el_lohnart,el_minr,el_ks,el_abrechdat,el_anzStunden,el_comment)
        SELECT 899, COALESCE(CAST(ll_allg1 AS INTEGER),ll_minr) AS minr, '',abrzeitAnf,COALESCE(ll_stuko_buch,0),lang_text(29215) /*'Stand verbuchtes Stundenkonto'*/
                  FROM llv
          WHERE EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth)
                AND ll_dolohnexport
                AND ( date_to_yearmonth_dec(ll_einstd) <= formonth)
                AND ( COALESCE(date_to_yearmonth_dec(ll_endd),formonth+1) >= formonth)
          ORDER BY minr;


   -- Nachtstunden, gehen auf Stammkostenstelle wenn diese angegeben ist
   INSERT INTO exportlohn (el_lohnart, el_minr, el_ks, el_abrechdat, el_anzStunden,el_comment)
        SELECT 2630, COALESCE(CAST(ll_allg1 AS INTEGER),bd_minr) AS minr, ll_ks,abrzeitAnf,SUM(COALESCE(bd_nachtstunden,0)), lang_text(29216) /*'Nachtstunden absolut'*/
                  FROM bdep JOIN llv ON bd_minr = ll_minr
                            JOIN mitpln ON (CAST(bd_anf AS DATE) = mpl_date) AND (mpl_minr = ll_minr)
                  WHERE mpl_formonth = formonth AND EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth) AND (ll_ks IS NOT NULL) AND ll_dolohnexport
          GROUP BY minr,ll_ks ORDER BY minr;
   DELETE FROM exportlohn WHERE el_anzstunden <= 0 AND el_lohnart = 2630;  -- Nachtstunden nicht übergeben wenn da 0 steht


   --***************************************************************************************
   -- Abwesenheiten: Krankheit, Urlaub, Urlaub 1/2 in Tagen, Alles andere in Stunden
   --***************************************************************************************

   -- Krankheit
   INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzTage,el_comment)
        SELECT 500,COALESCE(CAST(ll_allg1 AS INTEGER),mpl_minr) AS minr,'',abrzeitAnf,COUNT(1), lang_text(29217) /*'Abwesenheit Krankheit in Tagen'*/
          FROM bdepab JOIN mitpln ON mpl_minr=bdab_minr AND mpl_date BETWEEN bdab_anf AND bdab_end
                      JOIN llv ON mpl_minr = ll_minr
          WHERE mpl_formonth = formonth AND bdab_aus_id=2 AND EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth) AND ll_dolohnexport
          GROUP BY minr,ll_ks;

   -- Urlaub
   INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat,el_anzTage,el_comment)
        SELECT 400,COALESCE(CAST(ll_allg1 AS INTEGER),mpl_minr) AS minr,'',abrzeitAnf,COUNT(1),lang_text(29218) /*'Abwesenheit Urlaub in Tagen'*/
          FROM bdepab JOIN mitpln ON mpl_minr=bdab_minr AND mpl_date BETWEEN bdab_anf AND bdab_end
                      JOIN llv ON mpl_minr = ll_minr
          WHERE mpl_formonth = formonth AND bdab_aus_id=1 AND EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth) AND ll_dolohnexport
          GROUP BY minr,ll_ks;

   -- Urlaub 1/2
   INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat, el_anzTage,el_comment)
        SELECT 400,COALESCE(CAST(ll_allg1 AS INTEGER),mpl_minr) AS minr,'',abrzeitAnf,(COUNT(1)::NUMERIC/2),lang_text(29219) /*'Abwesenheit Urlaub 1/2 in Tagen'*/
          FROM bdepab JOIN mitpln ON mpl_minr=bdab_minr AND mpl_date BETWEEN bdab_anf AND bdab_end
                      JOIN llv ON mpl_minr = ll_minr
          WHERE mpl_formonth = formonth AND bdab_aus_id=100 AND EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth) AND ll_dolohnexport
          GROUP BY minr,ll_ks;

   --Alle anderen Abwesenheiten als Stunden
   INSERT INTO exportlohn (el_lohnart,el_minr,el_ks,el_abrechdat, el_anzStunden,el_comment)
        SELECT ab_allg1,COALESCE(CAST(ll_allg1 AS INTEGER),mpl_minr) AS minr,ab_allg2, abrzeitAnf,SUM(COALESCE(bdab_stu,tpl_abw)), ab_txt
                  FROM bdepab JOIN mitpln ON mpl_minr=bdab_minr AND mpl_date BETWEEN bdab_anf AND bdab_end
                              JOIN llv ON mpl_minr = ll_minr
                              LEFT OUTER JOIN bdeabgruende ON bdab_aus_id = ab_id
                              LEFT OUTER JOIN tplan ON mpl_tpl_name = tpl_name
                  WHERE mpl_formonth = formonth
                        --AND bdab_aus_id not in (1,2,100)
                        AND ab_allg1 IS NOT NULL AND EXISTS(SELECT true FROM llv_stuko_history WHERE llsh_ll_minr=ll_minr AND llsh_monthyear=formonth)
                        AND ll_dolohnexport
          GROUP BY minr,ab_txt, ab_allg2, ab_allg1;


   RETURN;

END $$ LANGUAGE plpgsql;


-- Datev Export: aktuelle Umsetzung Kreyenberg-spezifisch, bei Erweiterung des Exports zB um Feiertage bzw. Urlaub
-- zwingend Einschränkungen via Setting bzw. Kundenspezifisch einbauen um den Bestandsexport nicht zu behindern
CREATE OR REPLACE FUNCTION TPersonal.lohndaten_export__datev__create(
      _formonth            integer,
      _minr                integer = null,
      _abwesenheits_grund int[] = null
  ) RETURNS void AS $$
  DECLARE
      rec_mpl   record;
      start_dat date;
      end_dat   date;
  BEGIN

      FOR rec_mpl IN
          SELECT
            mpl_formonth,
            mpl_minr,
            bool_and( mpl_buch ) AS verbucht
          FROM mitpln
          WHERE
                mpl_formonth = _formonth
            AND (
                    _minr IS NULL
                OR  mpl_minr = _minr
            )
          GROUP BY mpl_formonth, mpl_minr
      LOOP
          -- zum Exportieren muss Monatsabschluss getätigt sein
          IF rec_mpl.verbucht THEN
              -- Start/Ende Datum des Monats ermitteln
              start_dat := yearmonth_dec_to_date( rec_mpl.mpl_formonth );
              end_dat   := yearmonth_dec_to_date( rec_mpl.mpl_formonth, true );

              -- Monatslohn bei konfigurierten Entgeltgruppen
              INSERT INTO exportLohn ( el_abrechdat, el_minr, el_lohnart, el_anzStunden, el_anzTage, el_loa_zusatz )
              SELECT
                mpl_date,
                mpl_minr,
                1000,
                mpl_saldo + mpl_absaldo - TPersonal.bdep__raucherpausen_summe__get( mpl_minr, mpl_date, mpl_date ), -- neu in #19032 mit Abzug Raucherpause
                1,
                1
              FROM mitpln
              WHERE
                    mpl_minr = rec_mpl.mpl_minr
                AND mpl_formonth = rec_mpl.mpl_formonth -- nur für den betroffenen Zeitraum
                AND mpl_saldo > 0
                --Wenn Mitarbeiter in Personal Entgletgruppe Lohn, dann werden die Einträge von LA 1000 forciert
                AND EXISTS (
                        SELECT true
                        FROM personal
                          JOIN llv ON ll_ad_krz = pers_krz
                        WHERE
                              ll_minr = mpl_minr
                          AND TSystem.ENUM_GetValue( TSystem.Settings__GetText( 'BDE.LohnUndGehalt.Export.Datev_Force_Stundenexport' ), pers_entgelt )
                    )
              ORDER BY mpl_date
              ;

              -- Urlaub/Krank
              INSERT INTO exportLohn ( el_abrechdat, el_minr,  el_lohnart, el_anzStunden, el_anzTage, el_loa_zusatz )
              SELECT
                bd.mpl_date,
                bd.mpl_minr,
                bdab.ab_allg1,
                mpl.mpl_min,
                1,
                bdab.ab_allg2
              FROM bdepabsum      AS bd -- VIEW mit identischen Feldern
                JOIN mitpln       AS mpl  ON bd.mpl_date = mpl.mpl_date AND mpl.mpl_minr = bd.mpl_minr
                JOIN bdeabgruende AS bdab ON bd.ab_id = bdab.ab_id
              -- evtl. auch mal in Einstellung auszulagern?
              WHERE
                    bd.ab_id = ANY( _abwesenheits_grund )
                AND bd.mpl_minr = rec_mpl.mpl_minr
                AND bd.mpl_date BETWEEN start_dat AND end_dat
              -- wieso group?
              GROUP BY bd.mpl_date, bd.mpl_minr, bdab.ab_allg1, mpl.mpl_min, bdab.ab_allg2
              ;

              -- Zuschläge ermitteln
              PERFORM TPersonal.bdep__lohnarten_zuschlaege__get(
                  _minr        => rec_mpl.mpl_minr,
                  _date_start  => start_dat,
                  _date_end    => end_dat,
                  _optimierung => TSystem.Settings__GetBool( 'BDE.Lohnart.KB_MA_LStSV_SpaetNacht_Optimierung' )
              );

          END IF;

      END LOOP;

      RETURN;
  END $$ LANGUAGE plpgsql;
--

--

-- #16540 Neue Mitarbeiter aus Domäne übernehmen: Mitarbeiter anlegen
CREATE OR REPLACE FUNCTION tpersonal.adk__llv__mitarbeiter__create(
    IN _ad_name         varchar,
    IN _ad_vorn         varchar,
    IN _ad_gebu         varchar,
    IN _ad_email1       varchar,
    IN _ad_tel1         varchar,
    IN _ll_abteilung    varchar,
    IN _ll_db_usename   varchar,
    IN _ll_win_usr      varchar
    )
    RETURNS varchar AS $$
    DECLARE _ad_krz   varchar;
            _minr     integer;

    BEGIN

      IF length( _ll_db_usename ) > 10 THEN
          RAISE EXCEPTION '%', format( lang_text(29778), _ll_db_usename );
      END IF;

      IF EXISTS( SELECT true FROM llv WHERE ll_db_usename = _ll_db_usename ) THEN
          RAISE EXCEPTION '%', format( lang_text( 29777 ), _ll_db_usename );
      END IF;


      -- TODO: Hier auch anpassen, wenn die Generierung des Adresskurzzeichen beim Anlegen eines neuen Mitarbeiters auf die DB-Funktion umgestellt wird. Ticket 17266
      --- ad_krz generieren
      -- SELECT TAdk.adk__ad_krz__generate(
      --     '',         -- Firma
      --     _ad_name,   -- Nachname
      --     _ad_vorn,   -- Vorname
      --     '',         -- Ort
      --     false       -- mitOrt
      -- ) INTO _ad_krz;
      _ad_krz := _ll_db_usename;

      --- adk anlegen
      INSERT INTO adk
        ( ad_krz, ad_name, ad_vorn, ad_vpber, ad_tel1, ad_email1 )
      VALUES
        -- Nutzerliste siehe llv
        ( _ad_krz, _ad_name, _ad_vorn, 1, _ad_tel1, _ad_email1 );

      --- personal anlegen
      INSERT INTO personal ( pers_krz )
        VALUES             ( _ad_krz );

      _minr := coalesce( ( SELECT max( ll_minr ) FROM llv ) + 1, 1 );
      --- llv anlegen
      INSERT INTO llv ( ll_minr, ll_ad_krz, ll_abteilung , ll_db_usename , ll_db_login, ll_passwd, ll_rfid, ll_win_usr )
        VALUES        ( _minr  , _ad_krz  , _ll_abteilung, _ll_db_usename, true       , null     , null   , _ll_win_usr );

      RETURN _ad_krz;
    END $$ LANGUAGE plpgsql;
--

-- #16540 Neue Mitarbeiter aus Domäne übernehmen: Serverseitige Passwortprüfung (Domäne)
CREATE OR REPLACE FUNCTION tpersonal.mitarbeiter__ll_db_usename__ll_passwd__password__check(
        IN _IN_ll_db_usename  varchar,
        IN _IN_ll_passwd      varchar,
        -- Optionale Parameter
        -- Funktion inet_server_addr() muss mit host() in eine Hostadresse gewandelt werden, bevor der Datentyp in varchar gewandelt werden kann.
        -- Ansonsten wird bei der Wandlung in varchar eine Netzwerkadresse *einschließlich* der Netzmaske (z.B. 135.201.123.44/48) anstatt der reinen IP-Adresse (116.201.123.44) zurückgegeben.
        IN _host           varchar = host(inet_server_addr())::varchar,
        IN _port           int = inet_server_port(),
        IN _dbname         varchar = current_database()::varchar
    ) RETURNS boolean AS $$
    DECLARE _connstring varchar;
            _ll_db_usename varchar;
            _ll_db_password varchar;
            _has_db_login bool;
    BEGIN
        -- Die interessierenden Spalten in Variablen lesen.
        SELECT ll_db_usename, ll_passwd, ll_db_login
          INTO _ll_db_usename, _ll_db_password, _has_db_login
          FROM  llv
         WHERE ll_db_usename = _IN_ll_db_usename;

        -- Der Benutzer existiert nicht in der llv-Tabelle.
        IF _ll_db_usename is null THEN
            RAISE NOTICE 'mitarbeiter__ll_db_usename__ll_passwd__password__check: user % not in table llv', _ll_db_usename;
            RETURN false;
        END IF;

        -- Der Benutzer hat ein DB-Login, heißt die Kennwortprüfung übernimmt postgres:
        --  die Prüfung über Postgres (zB Domänenlogin) wird angestoßen, wenn es *bei uns KEIN Passwort gibt!* (wird ja über die Domäne gesetzt, wir kennen es in unseren Daten gar nicht!)
        --  entsprechend muss die pg_hba.conf konfiguriert sein
        --  wenn es ansonsten bei uns ein Passwort gibt, aber pg_hba.conf auf "trust" steht - wird das Passwort komplett umgangen

        --  somit: will man eine externe Passwortprüfung, darf bei uns kein Passwort in der llv-tabelle stehen.e p
        IF     _has_db_login
           AND _ll_db_password IS null
        THEN
            _connstring := concat(   'host=', tsystem.quote_literal__connstr_param( _host ),
                                    ' port=', tsystem.quote_literal__connstr_param( _port::varchar ),
                                    ' dbname=', tsystem.quote_literal__connstr_param( _dbname ),
                                    ' user=', tsystem.quote_literal__connstr_param( _IN_ll_db_usename ),
                                    ' password=', tsystem.quote_literal__connstr_param( _IN_ll_passwd )
                                );

            BEGIN
                -- kann nur erfolgreich true zurückgeben, sonst immer exception
                RETURN * FROM dblink(   _connstring,
                                        'SELECT TRUE AS result;'
                                    ) AS temp ( result boolean );
            EXCEPTION
                WHEN OTHERS THEN
                    RAISE NOTICE 'mitarbeiter__ll_db_usename__ll_passwd__password__check: %', SQLERRM;
                    RETURN false;
            END;
        -- Interne Passwortprüfung, wenn Passwort in llv-Tabelle gesetzt ODER DB-Login NICHT vorhanden
        ELSE
           RETURN    coalesce(_ll_db_password = md5( _IN_ll_passwd )
                              , false
                              )
                  OR         (_ll_db_password IS null AND _IN_ll_passwd IS null);
        END IF;
    END $$ LANGUAGE plpgsql;
--

-- Mitarbeiter Zuordnung für multiple Abteilungen
CREATE TABLE llv_abteilungen
(
  lla_abteilung character varying(30) NOT NULL,
  lla_db_usename VARCHAR(10) NOT NULL
);

CREATE INDEX llv_abteilungen_usename_abteilung ON llv_abteilungen (lla_db_usename, lla_abteilung);

--

-- #17184 Überprüfung Berechtigung
CREATE OR REPLACE FUNCTION bdepab__b_05_iud__rights() RETURNS TRIGGER AS $$
  DECLARE _bdab_minr integer;
  BEGIN
    IF tg_op = 'UPDATE' AND (new IS NOT DISTINCT FROM old) THEN -- tpersonal.mitpln__saldo__recalc__prsz_neu: mitpln__a_iu() (Neuer Tag kann neuen Eintrag in mitpln hervorrufen, welches prsz_neu und somit update auf bdepab ohne Änderung zur Neuberechnung Saldo)
        RETURN new;
    END IF;

    IF TG_OP = 'DELETE' THEN
        _bdab_minr:= old.bdab_minr;
        IF old.bdab_aus_id IN (101, 103, 110, 111) --Mindestpause, Raucherpause, Pause, Abwesend Terminal
           OR EXISTS( -- dies ist Betriebsurlaub
                  SELECT true
                  FROM feiertag
                  WHERE ft_date = old.bdab_anf AND ft_urlaub
              )
           THEN
           -- die automatische Bewilligung, wie im anderen Fall, ist hier nicht berücksichtigt, da der Beantrager aktuell die eingetragende
           -- Abwesenheit nicht ändern kann, dass muss der Personalberechtigte machen
               RETURN old; --Die Abwesenheiten sind ausgenommen, müssen nicht genehmigt werden
        END IF;
    ELSE
        _bdab_minr:= new.bdab_minr;
        IF new.bdab_aus_id IN (101, 103, 110, 111) --Mindestpause, Raucherpause, Pause, Abwesend Terminal
           OR (SELECT ab_autobewill FROM bdeabgruende WHERE ab_id = new.bdab_aus_id)  --automatische Genehmigung
           OR  EXISTS( -- dies ist Betriebsurlaub
                  SELECT true
                  FROM feiertag
                  WHERE ft_date = new.bdab_anf AND ft_urlaub
                )
           THEN
              RETURN new; --Die Abwesenheiten sind ausgenommen, müssen nicht genehmigt werden
        END IF;
    END IF;

    -- für alle TG_OP die Prüfung ausführen
    -- Es wird hier 'revoke' für alles benutzt, da derzeit, dies implizit 'approve' bedingt
    -- Änderungen sind technisch betrachtet: 'revoke' -> 'add' -> 'edit' -> 'approve'
    IF NOT tpersonal.bde__user_rights_operation(
             current_user::VARCHAR,
             llv,
             'revoke'::TPersonal.bde__abwbew_operation,
             true, true, false
           ) FROM llv WHERE ll_minr = _bdab_minr
    THEN
      RAISE EXCEPTION 'bdepab__b_05_iud__rights: tpersonal.bde__user_rights_operation IS false xtt25525';
    END IF;

    IF TG_OP = 'UPDATE' OR TG_OP = 'INSERT' THEN
      RETURN new;
    END IF;
    IF TG_OP = 'DELETE' THEN
      RETURN old;
    END IF;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER bdepab__b_05_iud__rights
    BEFORE INSERT OR DELETE OR UPDATE
    OF bdab_minr, bdab_anf, bdab_anft, bdab_end, bdab_endt, bdab_stu, bdab_aus_id, bdab_bdabb_id, bdab_bd_id_anf, bdab_bd_id_end
       -- bdab_id, bdab_buch, bdab_bem, bdabb_bem_rtf, bdab_decider, bdab_decision_date
       -- #20235 bdab_buch darf nicht berücksichtigt werden, da beim Monatsabschluss gesetzt wird
    ON bdepab
    FOR EACH ROW
    EXECUTE PROCEDURE bdepab__b_05_iud__rights();

-- Log-Tabelle für BDE
CREATE TABLE bde__terminal__log
  (btl_id                SERIAL PRIMARY KEY,
   btl_manufacturer      VARCHAR(24), -- Hersteller ('DATAFOX', 'CIMPCS')
   btl_device_type       VARCHAR(32), -- Gerät ('evo28', 'evo35', 'evo35u', 'evo43', 'TFormBDEGetTime')
   btl_software_version  VARCHAR(24), -- Programm-Version auf dem Gerät ('04.03.12.11')

   -- Stempelprozess-Daten
   btl_rfid              VARCHAR(32), -- RFID
   btl_stempel_zeitpunkt TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL DEFAULT currenttime(), -- Stempelzeit (Kommen oder Gehen)
   btl_abw_id            INTEGER REFERENCES bdeabgruende, -- Abwesenheit (Gehen mit Abwesenheit)
   btl_terminal_info     VARCHAR(32), -- Terminal-Infos (Geräte-Nr, SN usw.)
   btl_net_ip            VARCHAR(24), -- IP des Terminals (zB '192.168.178.50')
   btl_bde_status_only   BOOLEAN,     -- nur BDE-Infos abfragen

   -- Ausgaben-Daten
   btl_event_id          INTEGER,     -- Ereignis-ID für ausgeführten Prozess (binärcodier: Kommen = 1, Gehen = 2, Info = 4)
   btl_msg               TEXT,        -- Fehler, Warnungen, Info, Exceptions
   btl_msg_type          VARCHAR(24)  -- Messagetyp als eigenes Feld, damit man einfach filtern kann
  );
--

-- Spielt Error-Log Daten ein (oder nur einen Datensatz, wenn _id eingegeben ist)
CREATE OR REPLACE FUNCTION TPersonal.bde__errorlog__execute(_ids integer[] = null) RETURNS VOID AS $$
DECLARE
  src_data record;
  return_rec record;
BEGIN
  FOR src_data IN SELECT
                    *
                  FROM
                    tlog.bdep__terminal_datafox__errorlog
                  WHERE
                    CASE WHEN _ids IS NOT null THEN
                          NOT(tde_status_only)
                      AND tde_id IN (SELECT unnest(_ids))
                    ELSE
                      NOT(tde_status_only)
                    END
                  ORDER BY tde_id
    LOOP
      BEGIN
        return_rec = TPersonal.bde__stempeln__terminal__execute(_manufacturer => 'DATAFOX',
                                                                _device_type => src_data.tde_device_type,
                                                                _software_version => src_data.tde_software_version,

                                                                -- Stempelprozess-Daten
                                                                _rfid => src_data.tde_rfid,
                                                                _minr => NULL,
                                                                _stempel_zeitpunkt => coalesce(src_data.tde_stempel_zeitpunkt, currenttime()),
                                                                _abw_id => nullif(src_data.tde_abw_id, 0),
                                                                _terminal_info => src_data.tde_terminal_info,
                                                                _net_ip => src_data.tde_net_ip,
                                                                _bde__status_only => src_data.tde_status_only
                                                               );
      EXCEPTION WHEN OTHERS
      THEN
        --RAISE NOTICE 'ERROR CODE: %. MESSAGE TEXT: %', SQLSTATE, SQLERRM;
        RAISE EXCEPTION '[tde_id: %]: %', src_data.tde_id, prodat_languages.lang_text__replace_xtt(SQLERRM);
      END;
      IF return_rec.msg_error IS NULL THEN
        --Übernommene Datensatz markieren
        UPDATE
          tlog.bdep__terminal_datafox__errorlog
        SET
          tde_done = true
        WHERE
          tde_id = src_data.tde_id;

        --Datensatz wurde übernommen
        --RAISE NOTICE '[tde_id: %]: ok', src_data.tde_id;
      ELSE
        --Rückgabefehler als Exception auslösen
        RAISE EXCEPTION '[tde_id: %]: %', src_data.tde_id, return_rec.msg_error;
      END IF;
    END LOOP;
  RETURN;
END $$ LANGUAGE plpgsql;
--
CREATE OR REPLACE FUNCTION TPersonal.bde__errorlog__execute(_id integer) RETURNS VOID AS $$
BEGIN
  PERFORM TPersonal.bde__errorlog__execute(ARRAY[_id]);
END $$ LANGUAGE plpgsql;
--